/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.inveed.commons.utils.ReflectionUtils;
import net.inveed.typeutils.AccessLevel;
import net.inveed.typeutils.BeanPropertyDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import net.inveed.typeutils.MethodMetadata;
import net.inveed.typeutils.ParameterMetadata;
import net.inveed.typeutils.PropertyUtils;
import net.inveed.typeutils.annotation.ParameterName;
import net.inveed.typeutils.annotation.PropertyAccessors;
import net.inveed.typeutils.annotation.PropertyIgnore;
import net.inveed.typeutils.ext.IMethodFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTypeDesc<T>
extends JavaTypeDesc<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BeanTypeDesc.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";
    private final Object _lock = new Object();
    private final Class<T> type;
    private final Constructor<?> defaultConstructor;
    private final List<Constructor<?>> constructors = new ArrayList();
    private List<BeanPropertyDesc> allProperies;
    private LinkedHashMap<String, BeanPropertyDesc> __properties;
    private LinkedHashMap<String, List<MethodMetadata>> __methods;
    private AccessLevel minGetterAccessLevel;
    private AccessLevel minSetterAccessLevel;
    private AccessLevel minFieldAccessLevel;

    protected BeanTypeDesc(Class<T> type) {
        PropertyAccessors paa;
        LOG.debug("Creating new type description for type {}", type);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.type = type;
        Constructor<Object> dc = null;
        try {
            try {
                dc = type.getConstructor(new Class[0]);
                LOG.debug("Found default public constructor");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Constructor<?>[] ctors = this.getType().getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                Constructor<?> ctor = ctors[i];
                if (ctor.getGenericParameterTypes().length == 0 && dc != null) {
                    dc = ctor;
                    LOG.debug("Found default non-public constructor");
                    break;
                }
                if (ctor.getGenericParameterTypes().length <= 0) continue;
                this.constructors.add(ctor);
            }
        }
        catch (SecurityException e) {
            LOG.warn("Cannot find default constructor for type " + this.getFullName(), (Throwable)e);
        }
        this.defaultConstructor = dc;
        if (this.defaultConstructor != null) {
            this.defaultConstructor.setAccessible(true);
        }
        if ((paa = type.getAnnotation(PropertyAccessors.class)) != null) {
            this.minFieldAccessLevel = paa.minimumFieldAccessLevel();
            this.minGetterAccessLevel = paa.minimumGetterAccessLevel();
            this.minSetterAccessLevel = paa.minimumSetterAccessLevel();
        } else {
            this.minFieldAccessLevel = AccessLevel.PUBLIC;
            this.minGetterAccessLevel = AccessLevel.PUBLIC;
            this.minSetterAccessLevel = AccessLevel.PUBLIC;
        }
    }

    protected BeanPropertyDesc createProperty(String name) {
        return new BeanPropertyDesc(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        if (this.isInitialized()) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.isInitialized()) {
                return;
            }
            LOG.debug("Initializing type description {}", (Object)this.getFullName());
            this.findProperties();
            this.findMethods();
            super.initialize();
        }
    }

    protected void findMethods() {
        LOG.debug("Searching for available methods");
        Method[] methodList = this.type.getDeclaredMethods();
        this.__methods = new LinkedHashMap();
        for (int i = 0; i < methodList.length; ++i) {
            int mods;
            Method method = methodList[i];
            if (method == null || Modifier.isStatic(mods = method.getModifiers())) continue;
            String name = method.getName();
            LOG.debug("Analyzing method '{}'", (Object)name);
            Annotation[][] allParametersAnnotations = method.getParameterAnnotations();
            int methodParamsSize = allParametersAnnotations.length;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            ArrayList<ParameterMetadata> parametersMetadata = new ArrayList<ParameterMetadata>();
            for (int pi = 0; pi < methodParamsSize; ++pi) {
                ParameterName pna = (ParameterName)ReflectionUtils.getAnnotation((Annotation[])allParametersAnnotations[pi], ParameterName.class);
                String pname = null;
                if (pna != null) {
                    pname = pna.value();
                }
                parametersMetadata.add(new ParameterMetadata(pname, parameterTypes[pi], genericParameterTypes[pi], pi, allParametersAnnotations[pi]));
            }
            MethodMetadata mm = new MethodMetadata(name, method, parametersMetadata);
            List<MethodMetadata> listByName = this.__methods.get(name);
            if (listByName == null) {
                listByName = new ArrayList<MethodMetadata>();
                this.__methods.put(name, listByName);
            }
            listByName.add(mm);
        }
    }

    protected void findProperties() {
        int i;
        LOG.debug("Searching for properties");
        HashMap<String, BeanPropertyDesc> propertiesByNativeNames = new HashMap<String, BeanPropertyDesc>();
        Method[] methodList = this.type.getDeclaredMethods();
        Field[] fieldsList = this.type.getDeclaredFields();
        LOG.debug("Analyzing getter/setter methods");
        for (i = 0; i < methodList.length; ++i) {
            BeanPropertyDesc pd;
            String propname;
            int mods;
            Method method = methodList[i];
            if (method == null || Modifier.isStatic(mods = method.getModifiers())) continue;
            if (method.getAnnotation(PropertyIgnore.class) != null) {
                LOG.debug("Skipping method {} because of PropertyIgnore annotation", (Object)method.toString());
                continue;
            }
            String name = method.getName();
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (name.length() <= 3 && !name.startsWith(IS_PREFIX)) {
                LOG.debug("Skipping method {} because of too short name", (Object)method.toString());
                continue;
            }
            if (argCount == 0) {
                if (name.startsWith(GET_PREFIX)) {
                    propname = PropertyUtils.normalizePropertyName(name.substring(3));
                    LOG.debug("Using method {} as simple getter for property {}", (Object)method.toString(), (Object)propname);
                    pd = (BeanPropertyDesc)propertiesByNativeNames.get(propname);
                    if (pd == null) {
                        pd = this.createProperty(propname);
                        propertiesByNativeNames.put(propname, pd);
                    }
                    pd.setGetter(method);
                    continue;
                }
                if (resultType == Boolean.TYPE && name.startsWith(IS_PREFIX)) {
                    propname = PropertyUtils.normalizePropertyName(name.substring(2));
                    LOG.debug("Using method {} as simple boolean getter for property {}", (Object)method.toString(), (Object)propname);
                    pd = (BeanPropertyDesc)propertiesByNativeNames.get(propname);
                    if (pd == null) {
                        pd = this.createProperty(propname);
                        propertiesByNativeNames.put(propname, pd);
                    }
                    pd.setGetter(method);
                    continue;
                }
                LOG.debug("Skipping method {}", (Object)method.toString());
                continue;
            }
            if (argCount == 1) {
                if (Integer.TYPE.equals(argTypes[0]) && name.startsWith(GET_PREFIX)) {
                    LOG.warn("Skipping method {} as simple index getter - NOT SUPPORTED", (Object)method.toString());
                    continue;
                }
                if (Void.TYPE.equals(resultType) && name.startsWith(SET_PREFIX)) {
                    propname = PropertyUtils.normalizePropertyName(name.substring(3));
                    LOG.debug("Using method {} as simple setter for property {}", (Object)method.toString(), (Object)propname);
                    pd = (BeanPropertyDesc)propertiesByNativeNames.get(propname);
                    if (pd == null) {
                        pd = this.createProperty(propname);
                        propertiesByNativeNames.put(propname, pd);
                    }
                    pd.setSetter(method);
                    continue;
                }
                LOG.debug("Skipping method {}", (Object)method.toString());
                continue;
            }
            if (argCount == 2) {
                if (name.startsWith(SET_PREFIX)) {
                    LOG.warn("Skipping method {} as simple index setter - NOT SUPPORTED", (Object)method.toString());
                    continue;
                }
                LOG.debug("Skipping method {}", (Object)method.toString());
                continue;
            }
            LOG.debug("Skipping method {}", (Object)method.toString());
        }
        LOG.debug("Analyzing fields");
        for (i = 0; i < fieldsList.length; ++i) {
            Field field = fieldsList[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (field.getAnnotation(PropertyIgnore.class) != null) {
                LOG.debug("Skipping field {} because of PropertyIgnore annotation", (Object)field.toString());
                continue;
            }
            String name = field.getName();
            LOG.debug("Using field {} for property {}", (Object)field.toString(), (Object)name);
            BeanPropertyDesc pd = (BeanPropertyDesc)propertiesByNativeNames.get(name);
            while (pd == null && name.startsWith("_")) {
                name = name.substring(1);
                pd = (BeanPropertyDesc)propertiesByNativeNames.get(name);
            }
            if (pd == null) {
                pd = this.createProperty(name);
            }
            pd.setField(field);
        }
        LOG.debug("Sorting fields");
        ArrayList propertiesList = new ArrayList(propertiesByNativeNames.values());
        Collections.sort(propertiesList, new Comparator<BeanPropertyDesc>(){

            @Override
            public int compare(BeanPropertyDesc f1, BeanPropertyDesc f2) {
                if (f1 == null && f2 == null) {
                    return 0;
                }
                if (f1 == null) {
                    return 1;
                }
                if (f2 == null) {
                    return -1;
                }
                if (f1.getOrder() == f2.getOrder()) {
                    return f1.getName().compareTo(f2.getName());
                }
                if (f1.getOrder() < f2.getOrder()) {
                    return -1;
                }
                return 1;
            }
        });
        LinkedHashMap<String, BeanPropertyDesc> ret = new LinkedHashMap<String, BeanPropertyDesc>();
        for (BeanPropertyDesc pd : propertiesList) {
            ret.put(pd.getName(), pd);
        }
        this.__properties = ret;
    }

    public String toString() {
        return "BeanTypeDesc {" + this.getType() + "}";
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        return this.type.getAnnotation(type);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> type) {
        return this.type.getDeclaredAnnotation(type);
    }

    public LinkedHashMap<String, BeanPropertyDesc> getDeclaredProperties() {
        if (this.__properties != null) {
            return this.__properties;
        }
        this.initialize();
        return this.__properties;
    }

    public LinkedHashMap<String, List<MethodMetadata>> getDeclaredMethods() {
        if (this.__methods != null) {
            return this.__methods;
        }
        this.initialize();
        return this.__methods;
    }

    public List<MethodMetadata> getMethods(String name, IMethodFilter filter) {
        HashMap<String, MethodMetadata> ret = new HashMap<String, MethodMetadata>();
        this.fillMethods(name, filter, ret);
        return new ArrayList<MethodMetadata>(ret.values());
    }

    public List<MethodMetadata> getMethods(String name) {
        return this.getMethods(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BeanPropertyDesc> getProperties() {
        if (this.allProperies != null) {
            return this.allProperies;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.allProperies != null) {
                return this.allProperies;
            }
            LOG.debug("Building list of all properties for bean description {}", (Object)this.getFullName());
            HashMap<String, BeanPropertyDesc> ret = new HashMap<String, BeanPropertyDesc>();
            for (BeanTypeDesc<?> current = this; current != null; current = current.getSupertype()) {
                for (BeanPropertyDesc bpd : current.getDeclaredProperties().values()) {
                    if (ret.containsKey(bpd.getName())) continue;
                    ret.put(bpd.getName(), bpd);
                }
            }
            this.allProperies = new ArrayList(ret.values());
            return this.allProperies;
        }
    }

    public BeanPropertyDesc getDeclaredProperty(String normalizedName) {
        return this.getDeclaredProperties().get(normalizedName);
    }

    public List<MethodMetadata> getDeclaredMethods(String name) {
        return Collections.unmodifiableList(this.getDeclaredMethods().get(name));
    }

    public BeanPropertyDesc getProperty(String name) {
        BeanPropertyDesc ret = this.getDeclaredProperty(name);
        if (ret == null && this.getSupertype() != null) {
            ret = this.getSupertype().getProperty(name);
        }
        return ret;
    }

    public String getFullName() {
        return this.type.getName();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Constructor<?> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public BeanTypeDesc<?> getSupertype() {
        if (this.type.getSuperclass() == Object.class) {
            return null;
        }
        JavaTypeDesc<T> ret = JavaTypeRegistry.getType(this.type.getSuperclass());
        if (ret instanceof BeanTypeDesc) {
            return (BeanTypeDesc)ret;
        }
        return null;
    }

    public String getShortName() {
        return this.type.getSimpleName();
    }

    AccessLevel getMinGetterAccessLevel() {
        return this.minGetterAccessLevel;
    }

    AccessLevel getMinSetterAccessLevel() {
        return this.minSetterAccessLevel;
    }

    AccessLevel getMinFieldAccessLevel() {
        return this.minFieldAccessLevel;
    }

    public Object newInstance() {
        if (this.defaultConstructor == null) {
            return null;
        }
        try {
            return this.defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.warn("Cannot create new instance with default constructor for type " + this.getFullName(), (Throwable)e);
            return null;
        }
    }

    protected void fillMethods(String name, IMethodFilter filter, HashMap<String, MethodMetadata> map) {
        List<MethodMetadata> l = this.getDeclaredMethods().get(name);
        if (l != null) {
            for (MethodMetadata mm : l) {
                String signature = mm.getSignature();
                if (map.containsKey(signature) || filter != null && !filter.isValid(mm)) continue;
                map.put(signature, mm);
            }
        }
        if (this.getSupertype() != null) {
            this.getSupertype().fillMethods(name, filter, map);
        }
    }
}

