/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.typeutils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.inveed.typeutils.BeanConfigurationException;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import net.inveed.typeutils.PropertyUtils;
import net.inveed.typeutils.ext.IBeanPropertyExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanPropertyDesc {
    private static final Logger LOG = LoggerFactory.getLogger(BeanPropertyDesc.class);
    private final Object _lock = new Object();
    private final HashMap<Class<? extends IBeanPropertyExtension>, IBeanPropertyExtension> extensions = new HashMap();
    private final BeanTypeDesc<?> beanType;
    private final String name;
    private int order;
    private JavaTypeDesc<?> propertyType;
    private BeanPropertyDesc overridedProperty = null;
    private boolean overridedPropertySet = false;
    private Field field;
    private Method getter;
    private Method setter;
    private AccessibleObject actualGetter;
    private AccessibleObject actualSetter;

    BeanPropertyDesc(String name, BeanTypeDesc<?> container) {
        this.name = PropertyUtils.normalizePropertyName(name);
        this.beanType = container;
    }

    protected boolean validateType(Class<?> t) {
        if (this.getType() == null) {
            return true;
        }
        JavaTypeDesc<?> testedType = JavaTypeRegistry.getType(t);
        if (testedType.isAssignableFrom(this.getType())) {
            return true;
        }
        if (this.getType().isAssignableFrom(testedType)) {
            return true;
        }
        LOG.warn("Type {} is not applicable for property {} with current type {}", new Object[]{t.getName(), this.toString(), testedType.getType().getName()});
        return false;
    }

    void setGetter(Method m) {
        if (!this.validateType(m.getReturnType())) {
            throw new BeanConfigurationException("Invalid getter type: " + m.getReturnType());
        }
        this.getter = m;
        this.propertyType = null;
    }

    void setSetter(Method m) {
        if (m.getGenericParameterTypes().length != 1) {
            throw new BeanConfigurationException("Setter with arguments count != 1 are not supported");
        }
        if (!this.validateType(m.getParameterTypes()[0])) {
            throw new BeanConfigurationException("Invalid setter type: " + m.getReturnType());
        }
        this.setter = m;
        this.propertyType = null;
    }

    void setField(Field f) {
        if (!this.validateType(f.getType())) {
            throw new BeanConfigurationException("Invalid field type: " + f.getType());
        }
        this.field = f;
        this.propertyType = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanPropertyDesc getOverridedProperty() {
        if (this.overridedPropertySet) {
            return this.overridedProperty;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.overridedPropertySet) {
                return this.overridedProperty;
            }
            if (this.getBeanType().getSupertype() != null) {
                this.overridedProperty = this.getBeanType().getSupertype().getProperty(this.getName());
            }
            this.overridedPropertySet = true;
            return this.overridedProperty;
        }
    }

    public BeanTypeDesc<?> getBeanType() {
        return this.beanType;
    }

    public Type getRawGetterType() {
        AccessibleObject getter = this.getGetter();
        if (getter == null) {
            LOG.warn("Trying to get raw getter type for property {}. Getter not found in target type.", (Object)this.toString());
            return null;
        }
        if (getter instanceof Method) {
            return ((Method)getter).getGenericReturnType();
        }
        if (getter instanceof Field) {
            return ((Field)getter).getGenericType();
        }
        LOG.warn("Trying to get raw getter type for property {}. Getter has unexpected type {}", (Object)this.toString(), (Object)getter.getClass().getName());
        return null;
    }

    public Class<?> getRawGetterClass() {
        AccessibleObject getter = this.getGetter();
        if (getter == null) {
            LOG.warn("Trying to get raw getter class for property {}. Getter not found in target type.", (Object)this.toString());
            return null;
        }
        if (getter instanceof Method) {
            return ((Method)getter).getReturnType();
        }
        if (getter instanceof Field) {
            return ((Field)getter).getType();
        }
        LOG.warn("Trying to get raw getter class for property {}. Getter has unexpected type {}", (Object)this.toString(), (Object)getter.getClass().getName());
        return null;
    }

    public Type getRawSetterType() {
        AccessibleObject setter = this.getSetter();
        if (setter == null) {
            LOG.warn("Trying to get raw setter type for property {}. Setter not found in target type.", (Object)this.toString());
            return null;
        }
        if (setter instanceof Method) {
            return ((Method)setter).getGenericParameterTypes()[0];
        }
        if (setter instanceof Field) {
            return ((Field)setter).getGenericType();
        }
        LOG.warn("Trying to get raw setter type for property {}. Setter has unexpected type {}", (Object)this.toString(), (Object)this.getter.getClass().getName());
        return null;
    }

    public Class<?> getRawSetterClass() {
        AccessibleObject setter = this.getSetter();
        if (setter == null) {
            LOG.warn("Trying to get raw setter class for property {}. Setter not found in target type.", (Object)this.toString());
            return null;
        }
        if (setter instanceof Method) {
            return ((Method)setter).getParameterTypes()[0];
        }
        if (setter instanceof Field) {
            return ((Field)setter).getType();
        }
        LOG.warn("Trying to get raw setter class for property {}. Setter has unexpected type {}", (Object)this.toString(), (Object)this.getter.getClass().getName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessibleObject getGetter() {
        if (this.actualGetter != null) {
            return this.actualGetter;
        }
        if (this.field == null && this.getter == null) {
            return null;
        }
        Object object = this._lock;
        synchronized (object) {
            this.actualGetter = PropertyUtils.select(this.field, this.getter, this.getBeanType().getMinFieldAccessLevel().getLevel(), this.getBeanType().getMinGetterAccessLevel().getLevel());
            if (this.actualGetter == null && this.getOverridedProperty() != null) {
                this.actualGetter = this.getOverridedProperty().getGetter();
            }
            return this.actualGetter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AccessibleObject getSetter() {
        if (this.actualSetter != null) {
            return this.actualSetter;
        }
        Object object = this._lock;
        synchronized (object) {
            this.actualSetter = PropertyUtils.select(this.field, this.setter, this.getBeanType().getMinFieldAccessLevel().getLevel(), this.getBeanType().getMinSetterAccessLevel().getLevel());
            if (this.actualSetter == null && this.getOverridedProperty() != null) {
                this.actualSetter = this.getOverridedProperty().getSetter();
            }
            return this.actualSetter;
        }
    }

    public boolean canGet() {
        if (this.getGetter() == null) {
            return false;
        }
        for (IBeanPropertyExtension be : this.extensions.values()) {
            if (be.canGet()) continue;
            return false;
        }
        return true;
    }

    public boolean canSet() {
        if (this.getSetter() == null) {
            return false;
        }
        for (IBeanPropertyExtension be : this.extensions.values()) {
            if (be.canSet()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaTypeDesc<?> getType() {
        if (this.propertyType != null) {
            return this.propertyType;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this.propertyType != null) {
                return this.propertyType;
            }
            if (this.getOverridedProperty() != null) {
                this.propertyType = this.getOverridedProperty().getType();
                return this.propertyType;
            }
            Class<?> getterType = this.getRawGetterClass();
            Class<?> setterType = this.getRawSetterClass();
            JavaTypeDesc<?> ret = null;
            if (getterType != null) {
                ret = JavaTypeRegistry.getType(getterType);
            }
            if (setterType != null) {
                JavaTypeDesc<?> st = JavaTypeRegistry.getType(setterType);
                if (ret == null || !ret.isAssignableFrom(st) && st.isAssignableFrom(ret)) {
                    ret = st;
                }
            }
            this.propertyType = ret;
        }
        return this.propertyType;
    }

    /*
     * Exception decompiling
     */
    public Object getValue(Object target) throws IllegalArgumentException, InvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean setValue(Object target, Object value) throws IllegalArgumentException, InvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends Annotation> T getAnnotation(Class<T> type) {
        T ret = null;
        AccessibleObject getterObj = this.getGetter();
        if (getterObj != null && (ret = (T)getterObj.getAnnotation(type)) != null) {
            return ret;
        }
        AccessibleObject setterObj = this.getSetter();
        if (setterObj != null && (ret = (T)setterObj.getAnnotation(type)) != null) {
            return ret;
        }
        if (this.field != null && getterObj instanceof Method && setterObj instanceof Method && (ret = (T)this.field.getAnnotation(type)) != null) {
            return ret;
        }
        if (this.getter != null && getterObj instanceof Field && (ret = (T)this.getter.getAnnotation(type)) != null) {
            return ret;
        }
        if (this.setter != null && setterObj instanceof Field && (ret = (T)this.setter.getAnnotation(type)) != null) {
            return ret;
        }
        return null;
    }

    public <E extends IBeanPropertyExtension> E getExtension(Class<E> type) {
        return (E)this.extensions.get(type);
    }

    public void registerExtension(IBeanPropertyExtension extension) {
        if (extension == null) {
            throw new NullPointerException("propertyExt is null");
        }
        if (this.extensions.containsKey(extension.getClass())) {
            throw new BeanConfigurationException("Extension with type " + extension.getClass().getName() + " already registered");
        }
        this.extensions.put(extension.getClass(), extension);
    }

    public String toString() {
        return "BeanProperty {" + this.getBeanType().getFullName() + " : " + this.getName() + "}";
    }
}

