/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.reflection.inject;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TypeHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T createInstance(Class<T> type) {
        Constructor<T> ctr = TypeHelper.getDefaultConstructor(type);
        if (ctr == null) {
            LOG.error("Cannot find default constructor for type " + type);
            return null;
        }
        boolean acc = ctr.isAccessible();
        ctr.setAccessible(true);
        try {
            T t = ctr.newInstance(new Object[0]);
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            LOG.error("Cannot create instance of class " + type + " using default constructor", (Throwable)e);
        }
        finally {
            ctr.setAccessible(acc);
        }
        return null;
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> type) {
        Constructor<?>[] ca;
        if (Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        if (Modifier.isInterface(type.getModifiers())) {
            return null;
        }
        for (Constructor<?> c : ca = type.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return c;
        }
        return null;
    }

    public static final Class<?> findLoadedClass(String classname) {
        try {
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            Object ret = m.invoke((Object)cl, classname);
            if (ret instanceof Class) {
                return (Class)ret;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }
}

