/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.reflection.inject;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import net.inveed.reflection.inject.ClassPreProcessor;
import net.inveed.reflection.inject.EntityExtensionTypeWrapper;
import net.inveed.reflection.inject.TypeWrapper;
import net.inveed.reflection.inject.annotations.EntityExtensionPkColumn;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalIdCache;

public class EntityTypeWrapper
extends TypeWrapper {
    private boolean isDirty = false;
    private List<CtField> idFields;

    protected EntityTypeWrapper(ClassPreProcessor injector, CtClass type, Class<?> javaClass) throws NotFoundException, ClassNotFoundException {
        super(injector, type, javaClass);
    }

    @Override
    protected void init() throws NotFoundException, ClassNotFoundException {
        super.init();
        this.idFields = this.findIdFields();
    }

    private List<CtField> findIdFields() {
        ArrayList<CtField> ret = new ArrayList<CtField>();
        for (CtField fld : this.getType().getFields()) {
            if (!fld.hasAnnotation(Id.class)) continue;
            ret.add(fld);
        }
        return ret;
    }

    public List<CtField> getIdFields() {
        return this.idFields;
    }

    @Override
    public void prepare() throws ClassNotFoundException, NotFoundException, CannotCompileException {
        Annotation cacheableAnnotation;
        if (Modifier.isFinal((int)this.getType().getModifiers())) {
            this.getType().setModifiers(Modifier.clear((int)this.getType().getModifiers(), (int)16));
        }
        boolean ctrOk = false;
        for (CtConstructor ctr : this.getType().getDeclaredConstructors()) {
            if (ctr.getDeclaringClass().getName() != this.getType().getName() || ctr.getParameterTypes().length != 0) continue;
            if (Modifier.isPrivate((int)ctr.getModifiers()) || Modifier.isPackage((int)ctr.getModifiers())) {
                ctr.setModifiers(Modifier.setProtected((int)ctr.getModifiers()));
                ctrOk = true;
                break;
            }
            if (!Modifier.isProtected((int)ctr.getModifiers()) && !Modifier.isPublic((int)ctr.getModifiers())) continue;
            ctrOk = true;
            break;
        }
        if (!ctrOk) {
            CtConstructor ctr = CtNewConstructor.defaultConstructor((CtClass)this.getType());
            ctr.setModifiers(Modifier.setProtected((int)ctr.getModifiers()));
            this.getType().addConstructor(ctr);
        }
        ConstPool constpool = this.getType().getClassFile().getConstPool();
        AnnotationsAttribute aattr = (AnnotationsAttribute)this.getType().getClassFile().getAttribute("RuntimeVisibleAnnotations");
        boolean adirty = false;
        boolean cacheable = false;
        ArrayList<Annotation> al = new ArrayList<Annotation>();
        for (Annotation annotation : aattr.getAnnotations()) {
            al.add(annotation);
        }
        if (!this.getType().hasAnnotation(Cacheable.class)) {
            cacheableAnnotation = new Annotation(Cacheable.class.getName(), constpool);
            cacheableAnnotation.addMemberValue("value", (MemberValue)new BooleanMemberValue(true, constpool));
            al.add(cacheableAnnotation);
            adirty = true;
            cacheable = true;
        } else {
            Cacheable c = (Cacheable)this.getType().getAnnotation(Cacheable.class);
            cacheable = c.value();
        }
        if (this.isNaturalIdCached() && !this.getType().hasAnnotation(NaturalIdCache.class) && cacheable) {
            Annotation naidCacheableAnnotation = new Annotation(NaturalIdCache.class.getName(), constpool);
            al.add(naidCacheableAnnotation);
            adirty = true;
        }
        if (!this.getType().hasAnnotation(Cache.class)) {
            cacheableAnnotation = new Annotation(Cache.class.getName(), constpool);
            EnumMemberValue usgValue = new EnumMemberValue(constpool);
            usgValue.setType(CacheConcurrencyStrategy.class.getName());
            usgValue.setValue(CacheConcurrencyStrategy.READ_WRITE.name());
            cacheableAnnotation.addMemberValue("usage", (MemberValue)usgValue);
            al.add(cacheableAnnotation);
            adirty = true;
        }
        if (adirty) {
            aattr.setAnnotations(al.toArray(new Annotation[0]));
            this.isDirty = true;
        }
        for (Annotation annotation : this.getType().getDeclaredFields()) {
            this.prepareField((CtField)annotation, constpool, cacheable);
        }
    }

    private void prepareField(CtField fld, ConstPool constpool, boolean cacheable) throws NotFoundException, CannotCompileException {
        boolean adirty = false;
        AnnotationsAttribute aattr = (AnnotationsAttribute)fld.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        if (aattr == null) {
            return;
        }
        ArrayList<Annotation> al = new ArrayList<Annotation>();
        for (Annotation col : aattr.getAnnotations()) {
            al.add(col);
        }
        if (cacheable && (fld.hasAnnotation(OneToMany.class) || fld.hasAnnotation(ManyToMany.class)) && !fld.hasAnnotation(Cache.class)) {
            Annotation cacheAnnotation = new Annotation(Cache.class.getName(), constpool);
            EnumMemberValue usgValue = new EnumMemberValue(constpool);
            usgValue.setType(CacheConcurrencyStrategy.class.getName());
            usgValue.setValue(CacheConcurrencyStrategy.READ_WRITE.name());
            cacheAnnotation.addMemberValue("usage", (MemberValue)usgValue);
            al.add(cacheAnnotation);
            adirty = true;
        }
        if (adirty) {
            aattr.setAnnotations(al.toArray(new Annotation[0]));
            this.isDirty = true;
            this.getType().removeField(fld);
            this.getType().addField(fld);
        }
    }

    private boolean modifyColumnDefinition(AnnotationsAttribute oaattr, AnnotationsAttribute naattr, EntityExtensionTypeWrapper ext, ConstPool constpool) {
        boolean ret = false;
        ArrayList<Annotation> al = new ArrayList<Annotation>();
        for (final Annotation col : oaattr.getAnnotations()) {
            final Annotation na = new Annotation(col.getTypeName(), constpool);
            if (col.getMemberNames() != null) {
                col.getMemberNames().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String name) {
                        MemberValue v = col.getMemberValue(name);
                        na.addMemberValue(name, v);
                    }
                });
            }
            if (col.getTypeName().equals(JoinColumn.class.getName()) || col.getTypeName().equals(Column.class.getName())) {
                this.setTableName(na, ext, constpool);
                ret = true;
            } else if (col.getTypeName().equals(ManyToMany.class.getName())) {
                // empty if block
            }
            al.add(na);
        }
        naattr.setAnnotations(al.toArray(new Annotation[0]));
        return ret;
    }

    private void setTableName(Annotation col, EntityExtensionTypeWrapper ext, ConstPool constpool) {
        MemberValue mv = col.getMemberValue("table");
        if (mv == null) {
            mv = new StringMemberValue(constpool);
            col.addMemberValue("table", mv);
        }
        if (mv instanceof StringMemberValue) {
            StringMemberValue sv = (StringMemberValue)mv;
            sv.setValue(ext.getExtensionAnnotation().tableName());
        }
    }

    public void extend(EntityExtensionTypeWrapper ext) throws CannotCompileException, NotFoundException {
        CtClass[] oaattr;
        this.isDirty = true;
        ConstPool constpool = this.getType().getClassFile().getConstPool();
        for (CtField ctField : ext.getType().getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers())) continue;
            CtField nfld = new CtField(ctField, this.getType());
            if (!Modifier.isTransient((int)nfld.getModifiers())) {
                oaattr = (CtClass[])ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
                AnnotationsAttribute aattr = (AnnotationsAttribute)nfld.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
                if (aattr == null || !this.modifyColumnDefinition((AnnotationsAttribute)oaattr, aattr, ext, constpool)) {
                    // empty if block
                }
            }
            this.getType().addField(nfld);
        }
        for (CtField ctField : ext.getType().getDeclaredMethods()) {
            if (Modifier.isStatic((int)ctField.getModifiers())) continue;
            CtMethod nm = new CtMethod((CtMethod)ctField, this.getType(), null);
            oaattr = (AnnotationsAttribute)ctField.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            AnnotationsAttribute naattr = (AnnotationsAttribute)nm.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            if (oaattr != null) {
                if (naattr == null) {
                    naattr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
                    nm.getMethodInfo().addAttribute((AttributeInfo)naattr);
                }
                this.modifyColumnDefinition((AnnotationsAttribute)oaattr, naattr, ext, constpool);
            }
            this.getType().addMethod(nm);
        }
        for (CtField ctField : ext.getType().getInterfaces()) {
            boolean inherited = false;
            for (CtClass di : this.getType().getInterfaces()) {
                if (di != ctField) continue;
                inherited = true;
                break;
            }
            if (inherited) continue;
            this.getType().addInterface((CtClass)ctField);
        }
        AnnotationsAttribute attrAnnotation = (AnnotationsAttribute)this.getType().getClassFile().getAttribute("RuntimeVisibleAnnotations");
        String secTableName = ext.getExtensionAnnotation().tableName().trim();
        if (secTableName.length() > 0) {
            Annotation secondaryTablesTypeAnnotation = attrAnnotation.getAnnotation(SecondaryTables.class.getName());
            if (secondaryTablesTypeAnnotation == null) {
                secondaryTablesTypeAnnotation = new Annotation(SecondaryTables.class.getName(), constpool);
                ArrayMemberValue arrayMemberValue = new ArrayMemberValue(constpool);
                arrayMemberValue.setValue(new MemberValue[0]);
                secondaryTablesTypeAnnotation.addMemberValue("value", (MemberValue)arrayMemberValue);
                attrAnnotation.addAnnotation(secondaryTablesTypeAnnotation);
            }
            Annotation annotation = new Annotation(SecondaryTable.class.getName(), constpool);
            annotation.addMemberValue("name", (MemberValue)new StringMemberValue(secTableName, constpool));
            ArrayMemberValue pks = new ArrayMemberValue(constpool);
            ArrayList<MemberValue> mvlist = new ArrayList<MemberValue>();
            for (EntityExtensionPkColumn clmn : ext.getExtensionAnnotation().pkColumns()) {
                Annotation pkAnnotation = new Annotation(PrimaryKeyJoinColumn.class.getName(), constpool);
                pkAnnotation.addMemberValue("name", (MemberValue)new StringMemberValue(clmn.name(), constpool));
                pkAnnotation.addMemberValue("referencedColumnName", (MemberValue)new StringMemberValue(clmn.referencedColumnName(), constpool));
                pkAnnotation.addMemberValue("columnDefinition", (MemberValue)new StringMemberValue(clmn.columnDefinition(), constpool));
                MemberValue mv = new AnnotationMemberValue(pkAnnotation, constpool);
                mvlist.add(mv);
            }
            pks.setValue(mvlist.toArray(new MemberValue[0]));
            annotation.addMemberValue("pkJoinColumns", (MemberValue)pks);
            ArrayMemberValue stables = (ArrayMemberValue)secondaryTablesTypeAnnotation.getMemberValue("value");
            ArrayList<Object> stablesList = new ArrayList<Object>();
            for (MemberValue mv : stables.getValue()) {
                stablesList.add(mv);
            }
            stablesList.add(new AnnotationMemberValue(annotation, constpool));
            stables.setValue(stablesList.toArray(new MemberValue[0]));
            attrAnnotation.addAnnotation(secondaryTablesTypeAnnotation);
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }
}

