/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.reflection.inject;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.persistence.Entity;
import net.inveed.reflection.inject.EntityExtensionTypeWrapper;
import net.inveed.reflection.inject.EntityTypeWrapper;
import net.inveed.reflection.inject.SimpleExtensionTypeWrapper;
import net.inveed.reflection.inject.SimpleTypeWrapper;
import net.inveed.reflection.inject.TypeWrapper;
import net.inveed.reflection.inject.annotations.EntityExtension;
import net.inveed.reflection.inject.annotations.SimpleExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPreProcessor.class);
    private ClassPool pool;
    private final HashMap<String, TypeWrapper> registeredTypes = new HashMap();
    private final ArrayList<TypeWrapper> interestingTypes = new ArrayList();
    private final ArrayList<Class<?>> interestingAnnotations = new ArrayList();
    private HashMap<Class<?>, List<Class<?>>> interestingTypesMap;
    private HashMap<Class<? extends Annotation>, List<Class<?>>> interestingAnnotationsMap;
    final HashMap<String, TypeWrapper> wrappers = new HashMap();

    public ClassPreProcessor() {
        this.pool = ClassPool.getDefault();
        this.pool.insertClassPath((ClassPath)new ClassClassPath(ClassPreProcessor.class));
    }

    public void registerInterest(Class<?> type) {
        if (Annotation.class.isAssignableFrom(type)) {
            if (this.interestingAnnotations.contains(type)) {
                return;
            }
            this.interestingAnnotations.add(type);
        } else {
            TypeWrapper tw;
            for (TypeWrapper rtw : this.interestingTypes) {
                if (!rtw.getType().getName().equals(type.getName())) continue;
                return;
            }
            try {
                tw = this.wrap(type);
            }
            catch (ClassNotFoundException | NotFoundException e) {
                return;
            }
            this.interestingTypes.add(tw);
        }
    }

    public void buildClasses() throws CannotCompileException, NotFoundException, ClassNotFoundException {
        for (TypeWrapper tw : this.registeredTypes.values()) {
            TypeWrapper ext;
            if (tw instanceof SimpleExtensionTypeWrapper) {
                ext = (SimpleExtensionTypeWrapper)tw;
                try {
                    ((SimpleExtensionTypeWrapper)ext).getTargetType().extend((SimpleExtensionTypeWrapper)ext);
                    continue;
                }
                catch (CannotCompileException | NotFoundException e) {
                    LOG.error("Cannot extend class '" + ((SimpleExtensionTypeWrapper)ext).getTargetType().getType().getName() + "' with extention '" + ext.getType().getName() + "'", e);
                    throw e;
                }
            }
            if (!(tw instanceof EntityExtensionTypeWrapper)) continue;
            ext = (EntityExtensionTypeWrapper)tw;
            try {
                ((EntityExtensionTypeWrapper)ext).getTargetType().extend((EntityExtensionTypeWrapper)ext);
            }
            catch (CannotCompileException | NotFoundException e) {
                LOG.error("Cannot extend class '" + ((EntityExtensionTypeWrapper)ext).getTargetType().getType().getName() + "' with extention '" + ext.getType().getName() + "'", e);
                throw e;
            }
        }
        for (TypeWrapper tw : this.registeredTypes.values()) {
            try {
                tw.prepare();
            }
            catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
                LOG.error("Cannot prepare class '" + tw.getType().getName() + "'.", e);
                throw e;
            }
        }
        for (TypeWrapper tw : this.registeredTypes.values()) {
            try {
                tw.toClass();
            }
            catch (CannotCompileException e) {
                LOG.error("Cannot compile class '" + tw.getType().getName() + "'.", (Throwable)e);
                throw e;
            }
        }
        for (TypeWrapper tw : this.registeredTypes.values()) {
            if (tw instanceof SimpleExtensionTypeWrapper || tw instanceof EntityExtensionTypeWrapper) continue;
            Class<?> cl = tw.toClass();
            if (!tw.isDirty()) continue;
            LOG.debug("DUMPED TYPE: ");
            this.dumpClass(cl, "");
            LOG.debug("-------------------------------");
        }
    }

    private void dumpClass(Class<?> c, String o) {
        LOG.debug(o + "CLASS: " + c.getName());
        o = o + " ";
        for (Annotation a : c.getAnnotations()) {
            LOG.debug(o + "  ANNOTATION: " + a.toString());
        }
        o = o + " ";
        for (Field f : c.getDeclaredFields()) {
            LOG.debug(o + " FIELD: " + f.getName() + " TYPE: " + f.getType());
            for (Annotation a : f.getAnnotations()) {
                LOG.debug(o + "  ANNOTATION: " + a.toString());
            }
        }
        if (c.getSuperclass() != null && c.getSuperclass() != Object.class) {
            this.dumpClass(c.getSuperclass(), o + " ");
        }
    }

    public void buildInterests() throws CannotCompileException, ClassNotFoundException, NotFoundException {
        this.buildClasses();
        HashMap interestingTypesMap = new HashMap();
        for (TypeWrapper t : this.interestingTypes) {
            ArrayList list = new ArrayList();
            interestingTypesMap.put(t.toClass(), list);
            for (TypeWrapper tw : this.wrappers.values()) {
                if (!tw.isInherited(t) && !tw.isImplemets(t)) continue;
                Class<?> tc = tw.toClass();
                list.add(tc);
            }
        }
        HashMap interestingAnnotationsMap = new HashMap();
        for (Class<?> t : this.interestingAnnotations) {
            ArrayList list = new ArrayList();
            interestingAnnotationsMap.put(t, list);
            for (TypeWrapper tw : this.wrappers.values()) {
                if (!tw.getType().hasAnnotation(t)) continue;
                Class<?> tc = tw.toClass();
                list.add(tc);
            }
        }
        this.interestingAnnotationsMap = interestingAnnotationsMap;
        this.interestingTypesMap = interestingTypesMap;
    }

    public List<Class<?>> getInterest(Class<?> type) {
        if (Annotation.class.isAssignableFrom(type)) {
            return Collections.unmodifiableList(this.interestingAnnotationsMap.get(type));
        }
        return Collections.unmodifiableList(this.interestingTypesMap.get(type));
    }

    public ClassPath insertClassPath(ClassPath cp) {
        return this.pool.insertClassPath(cp);
    }

    private TypeWrapper wrap(Class<?> type) throws NotFoundException, ClassNotFoundException {
        CtClass t = this.pool.get(type.getName());
        TypeWrapper tw = this.wrap(t, type);
        return tw;
    }

    public TypeWrapper wrap(String typeName) throws NotFoundException, ClassNotFoundException {
        CtClass type = this.pool.get(typeName);
        return this.wrap(type, null);
    }

    public TypeWrapper wrap(InputStream stream) throws NotFoundException, ClassNotFoundException, IOException, RuntimeException {
        CtClass type = this.pool.makeClass(stream);
        return this.wrap(type, null);
    }

    public TypeWrapper wrap(CtClass type, Class<?> javaClass) throws NotFoundException, ClassNotFoundException {
        if (this.wrappers.containsKey(type.getName())) {
            return this.wrappers.get(type.getName());
        }
        TypeWrapper tw = type.hasAnnotation(EntityExtension.class) ? new EntityExtensionTypeWrapper(this, type, javaClass) : (type.hasAnnotation(Entity.class) ? new EntityTypeWrapper(this, type, javaClass) : (type.hasAnnotation(SimpleExtension.class) ? new SimpleExtensionTypeWrapper(this, type, javaClass) : new SimpleTypeWrapper(this, type, javaClass)));
        return tw;
    }

    public void close() {
        for (TypeWrapper tw : this.registeredTypes.values()) {
            tw.getType().detach();
        }
        this.registeredTypes.clear();
        this.pool = null;
    }

    public void registerClass(InputStream stream) throws NotFoundException, ClassNotFoundException, IOException, RuntimeException {
        for (TypeWrapper tw = this.wrap(stream); tw != null; tw = tw.getSupertype()) {
            if (this.registeredTypes.containsKey(tw.getType().getName())) {
                return;
            }
            this.registeredTypes.put(tw.getType().getName(), tw);
        }
    }

    public void registerClass(String classname) throws NotFoundException, ClassNotFoundException {
        for (TypeWrapper tw = this.wrap(classname); tw != null; tw = tw.getSupertype()) {
            if (this.registeredTypes.containsKey(tw.getType().getName())) {
                return;
            }
            this.registeredTypes.put(tw.getType().getName(), tw);
        }
    }
}

