/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.core.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.inveed.commons.INumberedException;

public class ErrorMessage {
    @JsonProperty(value="code")
    private final long code;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="extended")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final ExtendedAttributes extended;

    public ErrorMessage(@JsonProperty(value="code") long code, @JsonProperty(value="message") String message) {
        this(code, message, null);
    }

    public ErrorMessage(long code, String message, ExtendedAttributes extended) {
        this.code = code;
        this.message = message;
        this.extended = extended;
    }

    public long getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "ErrorMessage{code='" + this.code + "', message=" + this.message + "}";
    }

    public static final class ExtendedAttributes {
        public String code;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Object[] args;

        public ExtendedAttributes(INumberedException e) {
            this.code = e.getCode().getCode();
            this.args = e.getArgs();
        }
    }
}

