/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server.typeutils;

import java.util.HashMap;
import java.util.List;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.commons.reflection.MethodMetadata;
import net.inveed.commons.reflection.ext.IBeanTypeExtension;
import net.inveed.commons.reflection.ext.IMethodExtension;
import net.inveed.jsonrpc.core.annotation.JsonRpcService;
import net.inveed.jsonrpc.server.typeutils.JsonRpcMethodExt;

public class JsonRpcTypeExt<T>
implements IBeanTypeExtension<T> {
    private static final HashMap<String, BeanTypeDesc<?>> services = new HashMap();
    private final BeanTypeDesc<T> type;
    private String serviceName;

    public JsonRpcTypeExt(BeanTypeDesc<T> beanType) {
        this.type = beanType;
        JsonRpcService svcAnnotation = (JsonRpcService)beanType.getAnnotation(JsonRpcService.class);
        if (svcAnnotation != null) {
            this.serviceName = svcAnnotation.value().trim().toLowerCase();
            if (this.serviceName.length() == 0) {
                this.serviceName = null;
                return;
            }
            services.put(this.serviceName, beanType);
        }
    }

    public static final BeanTypeDesc<?> getService(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if ((name = name.trim().toLowerCase()).length() == 0) {
            return null;
        }
        return services.get(name);
    }

    public boolean isValid() {
        return true;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public BeanTypeDesc<T> getBeanType() {
        return this.type;
    }

    public void initialize() {
        for (List mml : this.getBeanType().getDeclaredMethods().values()) {
            for (MethodMetadata mm : mml) {
                JsonRpcMethodExt me = new JsonRpcMethodExt(mm, this);
                if (!me.isValid()) continue;
                mm.registerExtension((IMethodExtension)me);
                me.initialize();
            }
        }
    }
}

