/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;
import net.inveed.jsonrpc.core.annotation.JsonRpcRequestScope;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

@Singleton
public class JsonRpcRequestScopeSingleton
implements Context<JsonRpcRequestScope> {
    private final ThreadLocal<Instance> currentScopeInstance = new ThreadLocal();
    private volatile boolean isActive = true;

    public Class<? extends Annotation> getScope() {
        return JsonRpcRequestScope.class;
    }

    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Instance instance = this.current();
        Object retVal = instance.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            instance.put(activeDescriptor, retVal);
        }
        return retVal;
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        Instance instance = this.current();
        return instance.contains(descriptor);
    }

    public boolean supportsNullCreation() {
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void destroyOne(ActiveDescriptor<?> descriptor) {
        Instance instance = this.current();
        instance.remove(descriptor);
    }

    private void setCurrent(Instance instance) {
        JsonRpcRequestScopeSingleton.checkState(this.isActive, "Request scope has been already shut down.");
        this.currentScopeInstance.set(instance);
    }

    private void resumeCurrent(Instance instance) {
        this.currentScopeInstance.set(instance);
    }

    public void shutdown() {
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInScope(Runnable task) {
        Instance oldInstance = this.retrieveCurrent();
        Instance instance = this.createInstance();
        try {
            this.setCurrent(instance);
            task.run();
        }
        finally {
            instance.release();
            this.resumeCurrent(oldInstance);
        }
    }

    public Instance referenceCurrent() throws IllegalStateException {
        return this.current().getReference();
    }

    private Instance current() {
        JsonRpcRequestScopeSingleton.checkState(this.isActive, "Request scope has been already shut down.");
        Instance scopeInstance = this.currentScopeInstance.get();
        JsonRpcRequestScopeSingleton.checkState(scopeInstance != null, "Not inside a request scope.");
        return scopeInstance;
    }

    private static void checkState(boolean bool, String string) {
        if (!bool) {
            throw new IllegalStateException(string);
        }
    }

    private Instance retrieveCurrent() {
        JsonRpcRequestScopeSingleton.checkState(this.isActive, "Request scope has been already shut down.");
        return this.currentScopeInstance.get();
    }

    public Instance suspendCurrent() {
        Instance scopeInstance = this.retrieveCurrent();
        if (scopeInstance == null) {
            return null;
        }
        return scopeInstance.getReference();
    }

    public Instance createInstance() {
        return new Instance();
    }

    public static class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(new JsonRpcRequestScopeSingleton()).to(JsonRpcRequestScopeSingleton.class);
        }
    }

    public static final class Instance {
        private final Map<ActiveDescriptor<?>, Object> store = new HashMap();
        private final AtomicInteger referenceCounter = new AtomicInteger(1);

        private Instance() {
        }

        private Instance getReference() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        <T> T get(ActiveDescriptor<T> descriptor) {
            return (T)this.store.get(descriptor);
        }

        <T> T put(ActiveDescriptor<T> descriptor, T value) {
            if (this.store.containsKey(descriptor)) {
                return null;
            }
            return (T)this.store.put(descriptor, value);
        }

        <T> void remove(ActiveDescriptor<T> descriptor) {
            Object removed = this.store.remove(descriptor);
            if (removed != null) {
                descriptor.dispose(removed);
            }
        }

        private <T> boolean contains(ActiveDescriptor<T> provider) {
            return this.store.containsKey(provider);
        }

        public void release() {
            if (this.referenceCounter.decrementAndGet() < 1) {
                for (ActiveDescriptor<?> descriptor : new ArrayList(this.store.keySet())) {
                    this.remove(descriptor);
                }
            }
        }
    }
}

