/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.inveed.jsonrpc.core.annotation.JsonRpcRequestScope;
import net.inveed.jsonrpc.core.domain.Response;
import net.inveed.jsonrpc.server.HK2JsonRpcServiceProvider;
import net.inveed.jsonrpc.server.IJsonRpcRequestContext;
import net.inveed.jsonrpc.server.JsonRpcRequestScopeSingleton;
import net.inveed.jsonrpc.server.servlet.JsonRpcRequestContext;
import net.inveed.jsonrpc.server.servlet.JsonRpcRequestHandler;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class JsonRpcServlet
extends HttpServlet {
    private static final long serialVersionUID = -4715104121483183130L;
    private final JsonConfiguration jsonConfig;
    private final HK2JsonRpcServiceProvider serviceLocator;

    public JsonRpcServlet() {
        ServiceLocator sl = ServiceLocatorUtilities.createAndPopulateServiceLocator();
        this.jsonConfig = new JsonConfiguration();
        this.serviceLocator = new HK2JsonRpcServiceProvider();
        this.serviceLocator.setServiceLocator(sl);
        ServiceLocatorUtilities.bind((ServiceLocator)sl, (Binder[])new Binder[]{new JsonRpcRequestScopeSingleton.Binder()});
        ServiceLocatorUtilities.bind((ServiceLocator)sl, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                this.bind(JsonRpcRequestContext.class).to(IJsonRpcRequestContext.class).proxy(false).proxyForSameScope(false).in(JsonRpcRequestScope.class);
            }
        }});
    }

    public ServiceLocator getServiceLocator() {
        return this.serviceLocator.getServiceLocator();
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Methods", "GET, POST, DELETE");
        resp.setHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, X-Auth-Token");
        super.doOptions(req, resp);
    }

    protected void doPost(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
        JsonRpcRequestScopeSingleton st = (JsonRpcRequestScopeSingleton)this.serviceLocator.getServiceLocator().getService(JsonRpcRequestScopeSingleton.class, new Annotation[0]);
        st.runInScope(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JsonRpcServlet.this.getRpcServiceLocator().register((Binder)new AbstractBinder(){

                    protected void configure() {
                        this.bind(req).to(HttpServletRequest.class);
                    }
                });
                IJsonRpcRequestContext ctx = (IJsonRpcRequestContext)JsonRpcServlet.this.serviceLocator.getServiceLocator().getService(IJsonRpcRequestContext.class, new Annotation[0]);
                ctx.setHttpServletRequest(req);
                ctx.setHttpServletResponse(resp);
                try {
                    JsonRpcRequestHandler srv = new JsonRpcRequestHandler(JsonRpcServlet.this.jsonConfig, JsonRpcServlet.this.serviceLocator);
                    Object response = srv.handle((InputStream)req.getInputStream());
                    if (response instanceof Response) {
                        resp.setStatus(((Response)response).getHttpStatusCode());
                    } else if (resp instanceof List) {
                        int status = 200;
                        for (Object o : (List)resp) {
                            Response r;
                            if (!(o instanceof Response) || (r = (Response)o).getHttpStatusCode() == 200) continue;
                            if (r.getHttpStatusCode() == 403) {
                                status = 403;
                                break;
                            }
                            if (r.getHttpStatusCode() == 500) {
                                status = r.getHttpStatusCode();
                                break;
                            }
                            status = Math.max(r.getHttpStatusCode(), status);
                        }
                        resp.setStatus(status);
                    }
                    resp.setHeader("Access-Control-Allow-Origin", "*");
                    resp.setHeader("Access-Control-Allow-Methods", "GET, POST, DELETE");
                    resp.setHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type, X-Auth-Token");
                    JsonRpcServlet.this.jsonConfig.getMapper().writer().writeValue((OutputStream)resp.getOutputStream(), response);
                    resp.getOutputStream().flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        ctx.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    public HK2JsonRpcServiceProvider getRpcServiceLocator() {
        return this.serviceLocator;
    }
}

