/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.inveed.jsonrpc.core.domain.ErrorMessage;
import net.inveed.jsonrpc.core.domain.ErrorResponse;
import net.inveed.jsonrpc.core.domain.Request;
import net.inveed.jsonrpc.core.domain.Response;
import net.inveed.jsonrpc.core.domain.SuccessResponse;
import net.inveed.jsonrpc.server.IJsonRpcServiceProvider;
import net.inveed.jsonrpc.server.servlet.JsonRpcMethodInvocationHandler;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcRequestHandler {
    private static final ErrorMessage PARSE_ERROR = new ErrorMessage(-32700L, "Cannot parse JSON-RPC request.", null);
    private static final ErrorMessage INVALID_REQUEST = new ErrorMessage(-32600L, "Invalid Request", null);
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcRequestHandler.class);
    private final JsonConfiguration mapper;
    private final IJsonRpcServiceProvider serviceProvider;

    public JsonRpcRequestHandler(JsonConfiguration mapper, IJsonRpcServiceProvider serviceProvider) {
        this.mapper = mapper;
        this.serviceProvider = serviceProvider;
    }

    public Object handle(InputStream inputStream) {
        JsonNode rootRequest;
        try {
            rootRequest = this.mapper.getMapper().readTree(inputStream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request : {}", (Object)this.mapper.getMapper().writeValueAsString((Object)rootRequest));
            }
        }
        catch (IOException e) {
            LOG.error(PARSE_ERROR.getMessage(), (Throwable)e);
            return new ErrorResponse(PARSE_ERROR, 400);
        }
        return this.handle(rootRequest);
    }

    public Object handle(JsonNode rootRequest) {
        if (rootRequest.isObject()) {
            Response response = this.handleSingleRequest(rootRequest);
            return JsonRpcRequestHandler.isNotification(rootRequest, response) ? null : response;
        }
        if (rootRequest.isArray() && rootRequest.size() > 0) {
            ArrayList<Object> responses = new ArrayList<Object>();
            for (JsonNode request : (ArrayNode)rootRequest) {
                Response response;
                if (!request.isObject()) {
                    responses.add(new ErrorResponse(INVALID_REQUEST, 400));
                }
                if (JsonRpcRequestHandler.isNotification(request, response = this.handleSingleRequest(request))) continue;
                responses.add(response);
            }
            return responses.size() > 0 ? responses.toArray(new Response[0]) : null;
        }
        LOG.error("Invalid JSON-RPC request: " + rootRequest);
        return new ErrorResponse(INVALID_REQUEST, 400);
    }

    private static boolean isNotification(JsonNode requestNode, Response response) {
        if (requestNode.get("id") == null) {
            long errorCode;
            if (response instanceof SuccessResponse) {
                return true;
            }
            if (response instanceof ErrorResponse && (errorCode = ((ErrorResponse)response).getError().getCode()) != PARSE_ERROR.getCode() && errorCode != INVALID_REQUEST.getCode()) {
                return true;
            }
        }
        return false;
    }

    private Response handleSingleRequest(JsonNode requestNode) {
        Request request;
        try {
            request = (Request)this.mapper.getMapper().convertValue((Object)requestNode, Request.class);
        }
        catch (Exception e) {
            LOG.error("Invalid JSON-RPC request: " + requestNode, (Throwable)e);
            return new ErrorResponse(INVALID_REQUEST, 400);
        }
        JsonRpcMethodInvocationHandler handler = new JsonRpcMethodInvocationHandler(this.mapper, request, this.serviceProvider);
        return handler.handle();
    }
}

