/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server.servlet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.inveed.commons.INumberedException;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.commons.reflection.JavaTypeDesc;
import net.inveed.commons.reflection.JavaTypeRegistry;
import net.inveed.commons.reflection.MethodMetadata;
import net.inveed.commons.reflection.ParameterMetadata;
import net.inveed.commons.utils.ReflectionUtils;
import net.inveed.jsonrpc.core.IHttpMethodException;
import net.inveed.jsonrpc.core.annotation.JsonRpcError;
import net.inveed.jsonrpc.core.domain.ErrorMessage;
import net.inveed.jsonrpc.core.domain.ErrorResponse;
import net.inveed.jsonrpc.core.domain.Request;
import net.inveed.jsonrpc.core.domain.Response;
import net.inveed.jsonrpc.core.domain.SuccessResponse;
import net.inveed.jsonrpc.server.IJsonRpcServiceProvider;
import net.inveed.jsonrpc.server.StringsUtil;
import net.inveed.jsonrpc.server.ThrowablesUtil;
import net.inveed.jsonrpc.server.typeutils.JsonRpcMethodExt;
import net.inveed.jsonrpc.server.typeutils.JsonRpcMethodParamExt;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcMethodInvocationHandler {
    private static final ErrorMessage METHOD_NOT_FOUND = new ErrorMessage(-32601L, "Method not found");
    private static final ErrorMessage INVALID_REQUEST = new ErrorMessage(-32600L, "Invalid Request");
    private static final int MIN_SERVER_ERROR_CODE = -32099;
    private static final int MAX_SERVER_ERROR_CODE = -32000;
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcMethodInvocationHandler.class);
    private static final String VERSION = "2.0";
    private final JsonConfiguration jsonConf;
    private final ObjectMapper mapper;
    private final IJsonRpcServiceProvider serviceProvider;
    private final Request request;
    private HashMap<String, JsonNode> managementParams = new HashMap();

    public JsonRpcMethodInvocationHandler(JsonConfiguration jsonConf, Request request, IJsonRpcServiceProvider serviceProvider) {
        this.mapper = jsonConf.getMapper();
        this.jsonConf = jsonConf;
        this.serviceProvider = serviceProvider;
        this.request = request;
    }

    private ErrorResponse handleError(Throwable ex) {
        Throwable rootCause = ThrowablesUtil.getRootCause(ex);
        int httpCode = 500;
        long jsonRpcCode = -32603L;
        String message = rootCause.getMessage();
        ErrorMessage.ExtendedAttributes ea = null;
        JsonRpcError jsonRpcErrorAnnotation = rootCause.getClass().getAnnotation(JsonRpcError.class);
        if (jsonRpcErrorAnnotation != null) {
            jsonRpcCode = jsonRpcErrorAnnotation.code() == 0 ? jsonRpcCode : (long)jsonRpcErrorAnnotation.code();
            message = StringsUtil.isNullOrEmpty(jsonRpcErrorAnnotation.message()) ? rootCause.getMessage() : jsonRpcErrorAnnotation.message();
            int n = httpCode = jsonRpcErrorAnnotation.httpCode() > 0 ? httpCode : jsonRpcErrorAnnotation.httpCode();
            if (jsonRpcCode < -32099L || jsonRpcCode > -32000L) {
                LOG.warn("Error code=" + jsonRpcCode + " not in a range [-32099;-32000]");
            }
            if (StringsUtil.isNullOrEmpty(message)) {
                LOG.warn("Error message should not be empty");
            }
        }
        if (rootCause instanceof IHttpMethodException) {
            httpCode = ((IHttpMethodException)rootCause).getHttpStatusCode();
        }
        if (rootCause instanceof INumberedException) {
            INumberedException ne = (INumberedException)rootCause;
            ea = new ErrorMessage.ExtendedAttributes(ne);
            jsonRpcCode = ne.getCode().getLongValue();
        }
        return new ErrorResponse(this.request.getId(), new ErrorMessage(jsonRpcCode, message, ea), httpCode);
    }

    public Response handle() {
        Object result;
        ValueNode id = this.request.getId();
        JsonNode params = this.request.getParams();
        ContainerNode<?> notNullParams = this.filterParams((ContainerNode)params);
        LOG.debug("Handling JSON-RPC request for method {} with {} params", (Object)this.request.getMethod(), (Object)notNullParams.size());
        if (this.request.getProtocolVersion() == null || this.request.getMethod() == null) {
            LOG.error("Not a JSON-RPC request: " + this.request);
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        if (!this.request.getProtocolVersion().equals(VERSION)) {
            LOG.error("Not a JSON-RPC 2.0 request: " + this.request);
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        if (!(params.isObject() || params.isArray() || params.isNull())) {
            LOG.error("Params of request: '" + this.request + "' should be an object, an array or null");
            return new ErrorResponse(id, INVALID_REQUEST);
        }
        Object serviceInstance = this.serviceProvider.getService(this.request.getMethod());
        if (serviceInstance == null) {
            LOG.warn("Cannot find service for method {}", (Object)this.request.getMethod());
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        LOG.debug("Got service object with type {}", (Object)serviceInstance.getClass().getName());
        String methodName = this.serviceProvider.getMethodName(this.request.getMethod());
        if (methodName == null) {
            LOG.warn("Cannot find service#method for method {}", (Object)this.request.getMethod());
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        JavaTypeDesc javaType = JavaTypeRegistry.getType(serviceInstance.getClass());
        if (!(javaType instanceof BeanTypeDesc)) {
            LOG.warn(serviceInstance.getClass() + " is not available as a JSON-RPC 2.0 service");
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        BeanTypeDesc classMetadata = (BeanTypeDesc)javaType;
        List methodsForName = classMetadata.getMethods(methodName, null);
        if (methodsForName == null || methodsForName.size() == 0) {
            LOG.error("Unable find a method: '" + methodName + "' in a " + serviceInstance.getClass());
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        LOG.debug("Found {} methods with name {}", (Object)methodsForName.size(), (Object)methodName);
        MethodMetadata selectedMethod = null;
        Object[] methodParams = null;
        for (MethodMetadata method : methodsForName) {
            List requiredParams;
            JsonRpcMethodExt me = (JsonRpcMethodExt)method.getExtension(JsonRpcMethodExt.class);
            if (me == null || (methodParams = this.convertToMethodParams(notNullParams, requiredParams = method.getParams())) == null) continue;
            selectedMethod = method;
            break;
        }
        if (selectedMethod == null) {
            LOG.error("Cannot find method '{}' with required params in a {}", (Object)methodName, serviceInstance.getClass());
            return new ErrorResponse(id, METHOD_NOT_FOUND);
        }
        try {
            result = selectedMethod.getMethod().invoke(serviceInstance, methodParams);
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
        if (result == null) {
            return new SuccessResponse(id, null);
        }
        int deep = 0;
        JsonNode deepParam = this.managementParams.get("#deep");
        if (deepParam != null) {
            deep = deepParam.asInt();
        }
        JsonNode retNode = this.jsonConf.serializeToNode(result, deep);
        return new SuccessResponse(id, retNode);
    }

    private ContainerNode<?> filterParams(ContainerNode<?> params) {
        if (params == null) {
            return this.mapper.createObjectNode();
        }
        if (params.isNull()) {
            return this.mapper.createObjectNode();
        }
        if (params.isArray()) {
            return params;
        }
        if (params.isObject()) {
            HashMap serviceParams = new HashMap();
            Iterator fields = params.fields();
            ObjectNode ret = this.mapper.createObjectNode();
            while (fields.hasNext()) {
                Map.Entry e = (Map.Entry)fields.next();
                if (((String)e.getKey()).startsWith("#") || ((String)e.getKey()).startsWith(".")) {
                    serviceParams.put(e.getKey(), e.getValue());
                    continue;
                }
                ret.set((String)e.getKey(), (JsonNode)e.getValue());
            }
            return ret;
        }
        return this.mapper.createObjectNode();
    }

    private Object[] convertToMethodParams(ContainerNode<?> params, List<ParameterMetadata> requiredParams) {
        int methodParamsSize = requiredParams.size();
        int jsonParamsSize = params.size();
        if (jsonParamsSize > methodParamsSize) {
            return null;
        }
        Object[] methodParams = new Object[methodParamsSize];
        int processed = 0;
        for (int index = 0; index < requiredParams.size(); ++index) {
            ParameterMetadata param = requiredParams.get(index);
            Class parameterType = param.getType();
            JsonRpcMethodParamExt pext = (JsonRpcMethodParamExt)param.getExtension(JsonRpcMethodParamExt.class);
            String name = pext != null ? pext.getName() : param.getName();
            JsonNode jsonNode = name != null ? (params.isObject() ? params.get(name) : params.get(index)) : (params.isObject() ? null : params.get(index));
            if (jsonNode == null || jsonNode.isNull()) {
                if (pext != null) {
                    if (!pext.isRequired()) {
                        methodParams[index] = this.getDefaultValue(parameterType);
                        if (jsonNode == null) continue;
                        ++processed;
                        continue;
                    }
                    return null;
                }
                methodParams[index] = this.getDefaultValue(parameterType);
                if (jsonNode == null) continue;
                ++processed;
                continue;
            }
            try {
                if (param.getType() == String.class && jsonNode.isObject()) {
                    methodParams[index] = this.mapper.writeValueAsString((Object)jsonNode);
                    ++processed;
                    continue;
                }
                JsonParser jsonParser = this.mapper.treeAsTokens((TreeNode)jsonNode);
                if (param.getType() == JsonParser.class) {
                    methodParams[index] = jsonParser;
                } else {
                    JavaType javaType = this.mapper.getTypeFactory().constructType(param.getGenericType());
                    methodParams[index] = this.mapper.readValue(jsonParser, javaType);
                }
                ++processed;
                continue;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (processed < jsonParamsSize) {
            return null;
        }
        return methodParams;
    }

    private Object getDefaultValue(Class<?> type) {
        if (type == Optional.class) {
            return Optional.empty();
        }
        if (type.isPrimitive()) {
            return ReflectionUtils.defaultValue(type);
        }
        return null;
    }
}

