/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.server.typeutils;

import java.util.HashMap;
import net.inveed.jsonrpc.core.annotation.JsonRpcMethod;
import net.inveed.jsonrpc.server.typeutils.JsonRpcMethodParamExt;
import net.inveed.jsonrpc.server.typeutils.JsonRpcTypeExt;
import net.inveed.typeutils.MethodMetadata;
import net.inveed.typeutils.ParameterMetadata;
import net.inveed.typeutils.ext.IMethodExtension;
import net.inveed.typeutils.ext.IParameterExtension;

public class JsonRpcMethodExt
implements IMethodExtension {
    private final MethodMetadata method;
    private final JsonRpcTypeExt<?> typeExt;
    private final String name;
    private HashMap<String, ParameterMetadata> namedParams = new HashMap();

    public JsonRpcMethodExt(MethodMetadata mm, JsonRpcTypeExt<?> jsonRpcTypeExt) {
        this.method = mm;
        this.typeExt = jsonRpcTypeExt;
        JsonRpcMethod ma = (JsonRpcMethod)mm.getAnnotation(JsonRpcMethod.class);
        this.name = ma == null ? null : (ma.value() == null || "".equals(ma.value()) ? mm.getName() : ma.value());
    }

    public void initialize() {
        for (ParameterMetadata p : this.method.getParams()) {
            JsonRpcMethodParamExt pe = new JsonRpcMethodParamExt(p, this);
            p.registerExtension((IParameterExtension)pe);
            if (pe.getName() == null) continue;
            this.namedParams.put(pe.getName().trim(), p);
        }
    }

    public ParameterMetadata getNamedParam(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        name = name.trim();
        return this.namedParams.get(name);
    }

    public MethodMetadata getMethod() {
        return this.method;
    }

    public JsonRpcTypeExt<?> getTypeExt() {
        return this.typeExt;
    }

    public boolean isValid() {
        return this.name != null;
    }
}

