/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.inveed.jsonrpc.client.Transport;
import net.inveed.jsonrpc.client.builder.AbstractBuilder;
import net.inveed.jsonrpc.client.exception.JsonRpcBatchException;
import net.inveed.jsonrpc.core.domain.ErrorMessage;

public class BatchRequestBuilder<K, V>
extends AbstractBuilder {
    private final List<ObjectNode> requests;
    private final Map<Object, JavaType> returnTypes;
    private final Class<K> keysType;
    private final JavaType returnType;

    public BatchRequestBuilder(Transport transport, ObjectMapper mapper) {
        this(transport, mapper, new ArrayList<ObjectNode>(), new HashMap<Object, JavaType>(), null, null);
    }

    public BatchRequestBuilder(Transport transport, ObjectMapper mapper, List<ObjectNode> requests, Map<Object, JavaType> returnTypes, Class<K> keysType, JavaType returnType) {
        super(transport, mapper);
        this.requests = requests;
        this.returnTypes = returnTypes;
        this.keysType = keysType;
        this.returnType = returnType;
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Object ... params) {
        this.requests.add(this.request((ValueNode)new LongNode(id), method, (JsonNode)this.arrayParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Object ... params) {
        this.requests.add(this.request((ValueNode)new IntNode(id), method, (JsonNode)this.arrayParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Object ... params) {
        this.requests.add(this.request((ValueNode)new TextNode(id), method, (JsonNode)this.arrayParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(String method, Object ... params) {
        this.requests.add(this.request((ValueNode)NullNode.instance, method, (JsonNode)this.arrayParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Map<String, ?> params) {
        this.requests.add(this.request((ValueNode)new LongNode(id), method, (JsonNode)this.objectParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Map<String, ?> params) {
        this.requests.add(this.request((ValueNode)new IntNode(id), method, (JsonNode)this.objectParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Map<String, ?> params) {
        this.requests.add(this.request((ValueNode)new TextNode(id), method, (JsonNode)this.objectParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(String method, Map<String, ?> params) {
        this.requests.add(this.request((ValueNode)NullNode.instance, method, (JsonNode)this.objectParams(params)));
        return this;
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Object[] params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Object[] params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Object[] params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Map<String, ?> params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Map<String, ?> params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Map<String, ?> params, Class<?> responseType) {
        return super.returnType((Object)id, responseType);
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Object[] params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Object[] params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Object[] params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    public BatchRequestBuilder<K, V> add(long id, String method, Map<String, ?> params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    public BatchRequestBuilder<K, V> add(int id, String method, Map<String, ?> params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    public BatchRequestBuilder<K, V> add(String id, String method, Map<String, ?> params, TypeReference<?> typeReference) {
        return super.returnType((Object)id, typeReference);
    }

    private BatchRequestBuilder<K, V> returnType(Object id, Class<?> responseType) {
        this.returnTypes.put(id, (JavaType)SimpleType.construct(responseType));
        return this;
    }

    private BatchRequestBuilder<K, V> returnType(Object id, TypeReference<?> typeReference) {
        this.returnTypes.put(id, this.mapper.getTypeFactory().constructType(typeReference.getType()));
        return this;
    }

    public <NK> BatchRequestBuilder<NK, V> keysType(Class<NK> keysClass) {
        return new BatchRequestBuilder<NK, V>(this.transport, this.mapper, this.requests, this.returnTypes, keysClass, this.returnType);
    }

    public <NV> BatchRequestBuilder<K, NV> returnType(Class<NV> valuesClass) {
        return new BatchRequestBuilder<K, V>(this.transport, this.mapper, this.requests, this.returnTypes, this.keysType, (JavaType)SimpleType.construct(valuesClass));
    }

    public <NV> BatchRequestBuilder<K, NV> returnType(TypeReference<NV> tr) {
        return new BatchRequestBuilder<K, V>(this.transport, this.mapper, this.requests, this.returnTypes, this.keysType, this.mapper.constructType(tr.getType()));
    }

    public Map<K, V> execute() {
        this.validateRequest();
        String textResponse = this.executeRequest();
        return this.processBatchResponse(textResponse);
    }

    private void validateRequest() {
        if (this.requests.isEmpty()) {
            throw new IllegalArgumentException("Requests are not set");
        }
        List<?> requestIds = this.requestIds();
        if (this.returnType == null) {
            for (Object id : requestIds) {
                if (this.returnTypes.containsKey(id)) continue;
                throw new IllegalArgumentException("Return type isn't specified for request with id='" + id + "'");
            }
        } else if (!this.returnTypes.isEmpty()) {
            throw new IllegalArgumentException("Common and detailed configurations of return types shouldn't be mixed");
        }
        for (Object id : requestIds) {
            this.checkIdType(id);
        }
    }

    private String executeRequest() {
        try {
            return this.transport.pass(this.mapper.writeValueAsString(this.requests));
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error during a request processing", e);
        }
    }

    private Map<K, V> processBatchResponse(String textResponse) {
        HashMap<Object, Object> successes = new HashMap<Object, Object>();
        HashMap<Object, ErrorMessage> errors = new HashMap<Object, ErrorMessage>();
        List<?> requestIds = this.requestIds();
        try {
            JsonNode jsonResponses = this.mapper.readTree(textResponse);
            if (jsonResponses.isTextual() && jsonResponses.asText().isEmpty() && requestIds.isEmpty()) {
                return new HashMap();
            }
            if (jsonResponses.getNodeType() != JsonNodeType.ARRAY) {
                throw new IllegalStateException("Expected array but was " + jsonResponses.getNodeType());
            }
            for (JsonNode responseNode : (ArrayNode)jsonResponses) {
                this.processSingleResponse(responseNode, requestIds, successes, errors);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable parse a JSON response: " + textResponse, e);
        }
        if (!errors.isEmpty()) {
            throw new JsonRpcBatchException("Errors happened during batch request processing", successes, errors);
        }
        return successes;
    }

    private void processSingleResponse(JsonNode responseNode, List<?> requestIds, Map<Object, Object> successes, Map<Object, ErrorMessage> errors) throws JsonProcessingException {
        this.checkVersion(responseNode, responseNode.get("jsonrpc"));
        JsonNode result = responseNode.get("result");
        JsonNode error = responseNode.get("error");
        if (error == null && result == null) {
            throw new IllegalStateException("Neither result or error is set in response: " + responseNode);
        }
        Object idValue = BatchRequestBuilder.nodeValue(responseNode.get("id"));
        if (this.keysType == Long.class && idValue.getClass() == Integer.class) {
            idValue = ((Integer)idValue).longValue();
        }
        if (!requestIds.contains(idValue)) {
            throw new IllegalStateException("Unspecified id: '" + idValue + "' in response");
        }
        if (result != null) {
            JavaType actualReturnType = this.returnType != null ? this.returnType : this.returnTypes.get(idValue);
            successes.put(idValue, this.mapper.convertValue((Object)result, actualReturnType));
        } else {
            errors.put(idValue, (ErrorMessage)this.mapper.treeToValue((TreeNode)error, ErrorMessage.class));
        }
    }

    private void checkVersion(JsonNode responseNode, JsonNode version) {
        if (version == null) {
            throw new IllegalStateException("Not a JSON-RPC response: " + responseNode);
        }
        if (!version.asText().equals("2.0")) {
            throw new IllegalStateException("Bad protocol version in a response: " + responseNode);
        }
    }

    private void checkIdType(Object id) {
        if (this.keysType != null && !this.keysType.equals(id.getClass())) {
            throw new IllegalArgumentException("Id: '" + id + "' has wrong type: '" + id.getClass().getSimpleName() + "'. Should be: '" + this.keysType.getSimpleName() + "'");
        }
    }

    private List<?> requestIds() {
        ArrayList<Object> ids = new ArrayList<Object>(this.requests.size());
        for (ObjectNode request : this.requests) {
            JsonNode id = request.get("id");
            if (id == null) continue;
            ids.add(BatchRequestBuilder.nodeValue(id));
        }
        return ids;
    }

    List<ObjectNode> getRequests() {
        return this.requests;
    }

    private static Object nodeValue(JsonNode id) {
        if (id.isLong()) {
            return id.longValue();
        }
        if (id.isInt()) {
            return id.intValue();
        }
        if (id.isTextual()) {
            return id.textValue();
        }
        throw new IllegalArgumentException("Wrong id=" + id);
    }
}

