/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.generator;

import net.inveed.jsonrpc.client.generator.SecureRandomIdGenerator;

public class SecureRandomStringIdGenerator
extends SecureRandomIdGenerator<String> {
    private static final char[] ALPHABET = "0123456789abcdef".toCharArray();
    private static final int DEFAULT_CHUNK_SIZE = 20;
    private final int chunkSize;

    public SecureRandomStringIdGenerator() {
        this.chunkSize = 20;
    }

    public SecureRandomStringIdGenerator(int idLength) {
        if (idLength < 2) {
            throw new IllegalArgumentException("Bad message length: '" + idLength + "'. It should be >= 2");
        }
        this.chunkSize = idLength / 2;
    }

    @Override
    public String generate() {
        byte[] buffer = new byte[this.chunkSize];
        this.secureRandom.nextBytes(buffer);
        return SecureRandomStringIdGenerator.hexString(buffer);
    }

    private static String hexString(byte[] source) {
        char[] result = new char[source.length * 2];
        for (int i = 0; i < source.length; ++i) {
            int unsigned = source[i] & 0xFF;
            int first4Bytes = unsigned >>> 4;
            int last4Bytes = unsigned & 0xF;
            result[i * 2] = ALPHABET[first4Bytes];
            result[i * 2 + 1] = ALPHABET[last4Bytes];
        }
        return new String(result);
    }
}

