/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.inveed.jsonrpc.client.Transport;
import net.inveed.jsonrpc.client.builder.AbstractBuilder;
import net.inveed.jsonrpc.client.exception.JsonRpcException;
import net.inveed.jsonrpc.core.domain.ErrorMessage;

public class RequestBuilder<T>
extends AbstractBuilder {
    private final String method;
    private final ValueNode id;
    private final ObjectNode objectParams;
    private final ArrayNode arrayParams;
    private final JavaType javaType;

    public RequestBuilder(Transport transport, ObjectMapper mapper) {
        super(transport, mapper);
        this.id = NullNode.instance;
        this.objectParams = mapper.createObjectNode();
        this.arrayParams = mapper.createArrayNode();
        this.method = "";
        this.javaType = SimpleType.construct(Object.class);
    }

    private RequestBuilder(Transport transport, ObjectMapper mapper, String method, ValueNode id, ObjectNode objectParams, ArrayNode arrayParams, JavaType javaType) {
        super(transport, mapper);
        this.method = method;
        this.id = id;
        this.objectParams = objectParams;
        this.arrayParams = arrayParams;
        this.javaType = javaType;
    }

    public RequestBuilder<T> id(Long id) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, (ValueNode)new LongNode(id.longValue()), this.objectParams, this.arrayParams, this.javaType);
    }

    public RequestBuilder<T> id(Integer id) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, (ValueNode)new IntNode(id.intValue()), this.objectParams, this.arrayParams, this.javaType);
    }

    public RequestBuilder<T> id(String id) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, (ValueNode)new TextNode(id), this.objectParams, this.arrayParams, this.javaType);
    }

    public RequestBuilder<T> method(String method) {
        return new RequestBuilder<T>(this.transport, this.mapper, method, this.id, this.objectParams, this.arrayParams, this.javaType);
    }

    public RequestBuilder<T> param(String name, Object value) {
        ObjectNode newObjectParams = this.objectParams.deepCopy();
        newObjectParams.set(name, this.mapper.valueToTree(value));
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, this.id, newObjectParams, this.arrayParams, this.javaType);
    }

    public RequestBuilder<T> params(Object ... values) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams(values), this.javaType);
    }

    public <NT> RequestBuilder<NT> returnAs(Class<NT> responseType) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)SimpleType.construct(responseType));
    }

    public <E> RequestBuilder<List<E>> returnAsList(Class<E> elementType) {
        return new RequestBuilder<List<E>>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, elementType));
    }

    public <E> RequestBuilder<Set<E>> returnAsSet(Class<E> elementType) {
        return new RequestBuilder<Set<E>>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)this.mapper.getTypeFactory().constructCollectionType(Set.class, elementType));
    }

    public <E> RequestBuilder<Collection<E>> returnAsCollection(Class<? extends Collection<?>> collectionType, Class<E> elementType) {
        return new RequestBuilder<Collection<E>>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)this.mapper.getTypeFactory().constructCollectionType(collectionType, elementType));
    }

    public <E> RequestBuilder<E[]> returnAsArray(Class<E> elementType) {
        return new RequestBuilder<E[]>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)this.mapper.getTypeFactory().constructArrayType(elementType));
    }

    public <V> RequestBuilder<Map<String, V>> returnAsMap(Class<? extends Map<?, ?>> mapClass, Class<V> valueType) {
        return new RequestBuilder<Map<String, V>>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, (JavaType)this.mapper.getTypeFactory().constructMapType(mapClass, String.class, valueType));
    }

    public <NT> RequestBuilder<NT> returnAs(TypeReference<NT> tr) {
        return new RequestBuilder<T>(this.transport, this.mapper, this.method, this.id, this.objectParams, this.arrayParams, this.mapper.getTypeFactory().constructType(tr.getType()));
    }

    public T execute() {
        T result = this.executeAndConvert();
        if (result == null) {
            throw new IllegalStateException("Response is null. Use 'executeNullable' if this is acceptable");
        }
        return result;
    }

    public T executeNullable() {
        return this.executeAndConvert();
    }

    private T executeAndConvert() {
        String textResponse = this.executeRequest();
        try {
            JsonNode responseNode = this.mapper.readTree(textResponse);
            JsonNode result = responseNode.get("result");
            JsonNode error = responseNode.get("error");
            JsonNode version = responseNode.get("jsonrpc");
            JsonNode id = responseNode.get("id");
            if (version == null) {
                throw new IllegalStateException("Not a JSON-RPC response: " + responseNode);
            }
            if (!version.asText().equals("2.0")) {
                throw new IllegalStateException("Bad protocol version in a response: " + responseNode);
            }
            if (id == null) {
                throw new IllegalStateException("Unspecified id in a response: " + responseNode);
            }
            if (error == null) {
                if (result != null) {
                    return (T)this.mapper.convertValue((Object)result, this.javaType);
                }
                throw new IllegalStateException("Neither result or error is set in a response: " + responseNode);
            }
            ErrorMessage errorMessage = (ErrorMessage)this.mapper.treeToValue((TreeNode)error, ErrorMessage.class);
            throw new JsonRpcException(errorMessage);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable parse a JSON response: " + textResponse, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error during a response processing", e);
        }
    }

    String executeRequest() {
        String textResponse;
        String textRequest;
        ObjectNode requestNode = this.request(this.id, this.method, this.params());
        try {
            textRequest = this.mapper.writeValueAsString((Object)requestNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable convert " + requestNode + " to JSON", e);
        }
        try {
            textResponse = this.transport.pass(textRequest);
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error during a request processing", e);
        }
        return textResponse;
    }

    private JsonNode params() {
        if (this.objectParams.size() > 0) {
            if (this.arrayParams.size() > 0) {
                throw new IllegalArgumentException("Both object and array params are set");
            }
            return this.objectParams;
        }
        return this.arrayParams;
    }
}

