/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.inveed.jsonrpc.client.ParamsType;
import net.inveed.jsonrpc.client.Transport;
import net.inveed.jsonrpc.client.builder.AbstractBuilder;
import net.inveed.jsonrpc.client.builder.Reflections;
import net.inveed.jsonrpc.client.exception.JsonRpcException;
import net.inveed.jsonrpc.client.generator.IdGenerator;
import net.inveed.jsonrpc.client.metadata.ClassMetadata;
import net.inveed.jsonrpc.client.metadata.MethodMetadata;
import net.inveed.jsonrpc.client.metadata.ParameterMetadata;
import net.inveed.jsonrpc.core.domain.ErrorMessage;

public class ObjectApiBuilder
extends AbstractBuilder
implements InvocationHandler {
    private ParamsType userParamsType;
    private IdGenerator<?> userIdGenerator;
    private ClassMetadata classMetadata;

    public ObjectApiBuilder(Class<?> clazz, Transport transport, ObjectMapper mapper, ParamsType userParamsType, IdGenerator<?> userIdGenerator) {
        super(transport, mapper);
        this.classMetadata = Reflections.getClassMetadata(clazz);
        this.userParamsType = userParamsType;
        this.userIdGenerator = userIdGenerator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodMetadata methodMetadata = this.classMetadata.getMethods().get(method);
        if (methodMetadata == null) {
            throw new IllegalStateException("Method '" + method.getName() + "' is not JSON-RPC available");
        }
        String methodName = methodMetadata.getName();
        JsonNode params = this.getParams(methodMetadata, args, this.getParamsType(this.classMetadata, methodMetadata));
        IdGenerator<?> idGenerator = this.userIdGenerator != null ? this.userIdGenerator : this.classMetadata.getIdGenerator();
        POJONode id = new POJONode(idGenerator.generate());
        String textResponse = this.execute(this.request((ValueNode)id, methodName, params));
        JsonNode responseNode = this.mapper.readTree(textResponse);
        JsonNode result = responseNode.get("result");
        JsonNode error = responseNode.get("error");
        if (result != null) {
            JavaType returnType = this.mapper.getTypeFactory().constructType(method.getGenericReturnType());
            if (returnType.getRawClass() == Void.TYPE) {
                return null;
            }
            return this.mapper.convertValue((Object)result, returnType);
        }
        ErrorMessage errorMessage = (ErrorMessage)this.mapper.treeToValue((TreeNode)error, ErrorMessage.class);
        throw new JsonRpcException(errorMessage);
    }

    private JsonNode getParams(MethodMetadata method, Object[] args, ParamsType paramsType) {
        ObjectNode paramsAsMap = this.mapper.createObjectNode();
        ArrayNode paramsAsArray = this.mapper.createArrayNode();
        for (String paramName : method.getParams().keySet()) {
            ParameterMetadata parameterMetadata = method.getParams().get(paramName);
            int index = parameterMetadata.getIndex();
            JsonNode jsonArg = this.mapper.valueToTree(args[index]);
            if (jsonArg == null || jsonArg == NullNode.instance) {
                if (parameterMetadata.isOptional()) {
                    if (paramsType != ParamsType.ARRAY) continue;
                    paramsAsArray.add((JsonNode)NullNode.instance);
                    continue;
                }
                throw new IllegalArgumentException("Parameter '" + paramName + "' of method '" + method.getName() + "' is mandatory and can't be null");
            }
            if (paramsType == ParamsType.MAP) {
                paramsAsMap.set(paramName, jsonArg);
                continue;
            }
            if (paramsType != ParamsType.ARRAY) continue;
            paramsAsArray.add(jsonArg);
        }
        return paramsType == ParamsType.MAP ? paramsAsMap : paramsAsArray;
    }

    private String execute(ObjectNode request) {
        try {
            return this.transport.pass(this.mapper.writeValueAsString((Object)request));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable convert " + request + " to JSON", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("I/O error during request processing", e);
        }
    }

    private ParamsType getParamsType(ClassMetadata classMetadata, MethodMetadata methodMetadata) {
        if (this.userParamsType != null) {
            return this.userParamsType;
        }
        if (methodMetadata.getParamsType() != null) {
            return methodMetadata.getParamsType();
        }
        if (classMetadata.getParamsType() != null) {
            return classMetadata.getParamsType();
        }
        return ParamsType.MAP;
    }
}

