/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.inveed.jsonrpc.client.JsonRpcId;
import net.inveed.jsonrpc.client.JsonRpcParams;
import net.inveed.jsonrpc.client.ParamsType;
import net.inveed.jsonrpc.client.generator.AtomicLongIdGenerator;
import net.inveed.jsonrpc.client.generator.IdGenerator;
import net.inveed.jsonrpc.client.metadata.ClassMetadata;
import net.inveed.jsonrpc.client.metadata.MethodMetadata;
import net.inveed.jsonrpc.client.metadata.ParameterMetadata;
import net.inveed.jsonrpc.core.annotation.JsonRpcMethod;
import net.inveed.jsonrpc.core.annotation.JsonRpcOptional;
import net.inveed.jsonrpc.core.annotation.JsonRpcParam;
import net.inveed.jsonrpc.core.annotation.JsonRpcService;

class Reflections {
    private Reflections() {
    }

    public static ClassMetadata getClassMetadata(Class<?> clazz) {
        HashMap<Method, MethodMetadata> methodsMetadata = new HashMap<Method, MethodMetadata>(32);
        for (Class<?> searchClass = clazz; searchClass != null; searchClass = searchClass.getSuperclass()) {
            Method[] methods;
            JsonRpcService rpcServiceAnn = Reflections.getAnnotation(searchClass.getAnnotations(), JsonRpcService.class);
            if (rpcServiceAnn == null) {
                throw new IllegalStateException("Class '" + clazz.getCanonicalName() + "' is not annotated as @JsonRpcService");
            }
            for (Method method : methods = searchClass.getMethods()) {
                Annotation[] methodAnnotations = method.getDeclaredAnnotations();
                JsonRpcMethod rpcMethodAnn = Reflections.getAnnotation(methodAnnotations, JsonRpcMethod.class);
                if (rpcMethodAnn == null) {
                    throw new IllegalStateException("Method '" + method.getName() + "' is not annotated as @JsonRpcMethod");
                }
                LinkedHashMap<String, ParameterMetadata> paramsMetadata = new LinkedHashMap<String, ParameterMetadata>(8);
                Annotation[][] parametersAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parametersAnnotations.length; ++i) {
                    Annotation[] parametersAnnotation = parametersAnnotations[i];
                    JsonRpcParam rpcParamAnn = Reflections.getAnnotation(parametersAnnotation, JsonRpcParam.class);
                    if (rpcParamAnn == null) {
                        throw new IllegalStateException("Parameter with index=" + i + " of method '" + method.getName() + "' is not annotated with @JsonRpcParam");
                    }
                    JsonRpcOptional optionalAnn = Reflections.getAnnotation(parametersAnnotation, JsonRpcOptional.class);
                    ParameterMetadata parameterMetadata = new ParameterMetadata(i, optionalAnn != null);
                    if (paramsMetadata.put(rpcParamAnn.value(), parameterMetadata) == null) continue;
                    throw new IllegalStateException("Two parameters of method '" + method.getName() + "' have the " + "same name '" + rpcParamAnn.value() + "'");
                }
                String name = !rpcMethodAnn.value().isEmpty() ? rpcMethodAnn.value() : method.getName();
                ParamsType paramsType = Reflections.getParamsType(methodAnnotations);
                methodsMetadata.put(method, new MethodMetadata(name, paramsType, paramsMetadata));
            }
        }
        Annotation[] classAnnotations = clazz.getDeclaredAnnotations();
        IdGenerator<?> idGenerator = Reflections.getIdGenerator(classAnnotations);
        ParamsType paramsType = Reflections.getParamsType(classAnnotations);
        return new ClassMetadata(paramsType, idGenerator, methodsMetadata);
    }

    private static IdGenerator<?> getIdGenerator(Annotation[] classAnnotations) {
        JsonRpcId jsonRpcIdAnn = Reflections.getAnnotation(classAnnotations, JsonRpcId.class);
        Class idGeneratorClazz = jsonRpcIdAnn == null ? AtomicLongIdGenerator.class : jsonRpcIdAnn.value();
        try {
            return (IdGenerator)idGeneratorClazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable instantiate id generator: " + idGeneratorClazz, e);
        }
    }

    private static ParamsType getParamsType(Annotation[] annotations) {
        JsonRpcParams rpcParamsAnn = Reflections.getAnnotation(annotations, JsonRpcParams.class);
        return rpcParamsAnn != null ? rpcParamsAnn.value() : null;
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> clazz) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(clazz)) continue;
                return (T)annotation;
            }
        }
        return null;
    }
}

