/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Map;
import net.inveed.jsonrpc.client.Transport;

public class AbstractBuilder {
    protected static final String VERSION_2_0 = "2.0";
    protected static final String RESULT = "result";
    protected static final String ERROR = "error";
    protected static final String JSONRPC = "jsonrpc";
    protected static final String ID = "id";
    protected static final String METHOD = "method";
    protected static final String PARAMS = "params";
    protected final Transport transport;
    protected final ObjectMapper mapper;

    public AbstractBuilder(Transport transport, ObjectMapper mapper) {
        this.transport = transport;
        this.mapper = mapper;
    }

    protected ArrayNode arrayParams(Object[] values) {
        ArrayNode newArrayParams = this.mapper.createArrayNode();
        for (Object value : values) {
            newArrayParams.add(this.mapper.valueToTree(value));
        }
        return newArrayParams;
    }

    protected ObjectNode objectParams(Map<String, ?> params) {
        ObjectNode objectNode = this.mapper.createObjectNode();
        for (String key : params.keySet()) {
            objectNode.set(key, this.mapper.valueToTree(params.get(key)));
        }
        return objectNode;
    }

    protected ObjectNode request(ValueNode id, String method, JsonNode params) {
        if (method.isEmpty()) {
            throw new IllegalArgumentException("Method is not set");
        }
        ObjectNode requestNode = this.mapper.createObjectNode();
        requestNode.put(JSONRPC, VERSION_2_0);
        requestNode.put(METHOD, method);
        requestNode.set(PARAMS, params);
        if (!id.isNull()) {
            requestNode.set(ID, (JsonNode)id);
        }
        return requestNode;
    }
}

