/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.jsonrpc.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import net.inveed.jsonrpc.client.ParamsType;
import net.inveed.jsonrpc.client.Transport;
import net.inveed.jsonrpc.client.builder.BatchRequestBuilder;
import net.inveed.jsonrpc.client.builder.NotificationRequestBuilder;
import net.inveed.jsonrpc.client.builder.ObjectApiBuilder;
import net.inveed.jsonrpc.client.builder.RequestBuilder;
import net.inveed.jsonrpc.client.generator.IdGenerator;

public class JsonRpcClient {
    private Transport transport;
    private ObjectMapper mapper;

    public JsonRpcClient(Transport transport) {
        this(transport, new ObjectMapper());
    }

    public JsonRpcClient(Transport transport, ObjectMapper mapper) {
        this.transport = transport;
        this.mapper = mapper;
    }

    public RequestBuilder<Object> createRequest() {
        return new RequestBuilder<Object>(this.transport, this.mapper);
    }

    public NotificationRequestBuilder createNotification() {
        return new NotificationRequestBuilder(this.transport, this.mapper);
    }

    public BatchRequestBuilder<?, ?> createBatchRequest() {
        return new BatchRequestBuilder(this.transport, this.mapper);
    }

    public <T> T onDemand(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectApiBuilder(clazz, this.transport, this.mapper, null, null));
    }

    public <T> T onDemand(Class<T> clazz, IdGenerator<?> idGenerator) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectApiBuilder(clazz, this.transport, this.mapper, null, idGenerator));
    }

    public <T> T onDemand(Class<T> clazz, ParamsType paramsType) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectApiBuilder(clazz, this.transport, this.mapper, paramsType, null));
    }

    public <T> T onDemand(Class<T> clazz, ParamsType paramsType, IdGenerator<?> idGenerator) {
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectApiBuilder(clazz, this.transport, this.mapper, paramsType, idGenerator));
    }
}

