/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import net.inveed.commons.reflection.JavaTypeDesc;
import net.inveed.commons.reflection.JavaTypeRegistry;
import net.inveed.commons.reflection.NativeTypeDesc;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;

public class JsonTypeUtils {
    public static Object getPrimitive(JavaTypeDesc<?> t, JsonParser p) throws IOException {
        if (t instanceof NativeTypeDesc) {
            NativeTypeDesc type = (NativeTypeDesc)t;
            if (type.isInt()) {
                return p.getValueAsInt();
            }
            if (type.isByte()) {
                return (byte)p.getValueAsInt();
            }
            if (type.isShort()) {
                return (short)p.getValueAsInt();
            }
            if (type.isLong()) {
                return p.getValueAsLong();
            }
            if (type.isFloat()) {
                return Float.valueOf((float)p.getValueAsDouble());
            }
            if (type.isDouble()) {
                return p.getValueAsDouble();
            }
            if (type.isBoolean()) {
                return p.getValueAsBoolean();
            }
            if (type.isChar()) {
                return Character.valueOf(p.getTextCharacters()[0]);
            }
            if (type.isString()) {
                return p.getValueAsString();
            }
            if (type.isUUID()) {
                return UUID.fromString(p.getValueAsString());
            }
            if (type.isDate()) {
                return Date.parse(p.getValueAsString());
            }
        }
        return null;
    }

    public static final String getEntityName(Class<?> entityType) {
        if (entityType == null) {
            return null;
        }
        JavaTypeDesc type = JavaTypeRegistry.getType(entityType);
        if (type == null) {
            return entityType.getSimpleName();
        }
        EntityTypeExt ete = (EntityTypeExt)type.getExtension(EntityTypeExt.class);
        if (ete == null) {
            return entityType.getSimpleName();
        }
        return ete.getEntityName();
    }
}

