/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import net.inveed.commons.reflection.BeanTypeDesc;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;

public class CRUDEntityProcessor {
    public <T> List<T> list(EntityManager em, Class<T> type, int pageSize, int page) {
        if (page <= 0) {
            page = 1;
        }
        if (pageSize <= 0) {
            pageSize = 50;
        }
        int startPos = pageSize * (page - 1);
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery q = cb.createQuery(type);
        Root root = q.from(type);
        q = q.select((Selection)root);
        TypedQuery query = em.createQuery(q);
        return query.setFirstResult(startPos).setMaxResults(pageSize).getResultList();
    }

    public <T> T get(EntityManager em, BeanTypeDesc<T> entityType, String id) throws JsonGenerationException, JsonMappingException, IOException {
        if (!em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded((Object)entityType.getType())) {
            return null;
        }
        EntityTypeExt ete = (EntityTypeExt)entityType.getExtension(EntityTypeExt.class);
        return ete.get(em, id);
    }
}

