/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.typeutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import net.inveed.rest.jpa.IEntityInstantiator;
import net.inveed.rest.jpa.annotations.EntityInstantiator;
import net.inveed.rest.jpa.typeutils.EntityPropertyExt;
import net.inveed.typeutils.BeanPropertyDesc;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import net.inveed.typeutils.TypeUtils;
import net.inveed.typeutils.ext.IBeanPropertyExtension;
import net.inveed.typeutils.ext.IBeanTypeExtension;

public class EntityTypeExt<T>
implements IBeanTypeExtension<T> {
    private static final HashMap<String, BeanTypeDesc<?>> entityMap = new HashMap();
    private final BeanTypeDesc<T> type;
    private final String entityName;
    private final String tableName;
    private boolean mappedSuperclass = false;
    private final List<BeanPropertyDesc> idFields;

    public EntityTypeExt(BeanTypeDesc<T> type) {
        this.type = type;
        this.idFields = new ArrayList<BeanPropertyDesc>();
        Entity annEntity = (Entity)type.getAnnotation(Entity.class);
        if (annEntity != null) {
            this.entityName = annEntity.name().equals("") ? type.getShortName() : annEntity.name();
            entityMap.put(this.entityName, type);
            Table ta = (Table)type.getAnnotation(Table.class);
            this.tableName = ta != null ? ta.name() : null;
        } else {
            MappedSuperclass annMS = (MappedSuperclass)type.getAnnotation(MappedSuperclass.class);
            if (annMS != null) {
                this.mappedSuperclass = true;
                this.entityName = type.getShortName();
                entityMap.put(this.entityName, type);
                this.tableName = null;
            } else {
                this.entityName = null;
                this.tableName = null;
            }
        }
    }

    public static final BeanTypeDesc<?> getEntity(String name) {
        return entityMap.get(name);
    }

    public boolean isValid() {
        return this.entityName != null;
    }

    public boolean isMappedSuperclass() {
        return this.mappedSuperclass;
    }

    public BeanTypeDesc<T> getBeanType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void initialize() {
        for (BeanPropertyDesc bpd : this.type.getDeclaredProperties().values()) {
            bpd.registerExtension((IBeanPropertyExtension)new EntityPropertyExt(bpd));
        }
        this.processIdFields();
    }

    protected void processIdFields() {
        for (BeanPropertyDesc f : this.type.getDeclaredProperties().values()) {
            EntityPropertyExt epe = (EntityPropertyExt)f.getExtension(EntityPropertyExt.class);
            if (epe == null || !epe.isId()) continue;
            this.idFields.add(f);
        }
    }

    public List<BeanPropertyDesc> getIDFields() {
        EntityTypeExt superEntity;
        if (this.getBeanType().getSupertype() != null && (superEntity = (EntityTypeExt)this.getBeanType().getSupertype().getExtension(EntityTypeExt.class)) != null) {
            return superEntity.getIDFields();
        }
        return Collections.unmodifiableList(this.idFields);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public IEntityInstantiator<?, ?> getInstantiator() {
        EntityInstantiator eia = (EntityInstantiator)this.type.getAnnotation(EntityInstantiator.class);
        if (eia == null) {
            if (this.type.getSupertype() != null) {
                EntityTypeExt parentExt = (EntityTypeExt)this.type.getSupertype().getExtension(EntityTypeExt.class);
                if (parentExt == null) {
                    return null;
                }
                return parentExt.getInstantiator();
            }
            return null;
        }
        try {
            Class iclass = eia.value();
            Constructor ctr = iclass.getDeclaredConstructor(new Class[0]);
            ctr.setAccessible(true);
            return (IEntityInstantiator)ctr.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return null;
        }
    }

    public T get(EntityManager em, Object id) {
        EntityTypeExt idEntityExt;
        Object oid;
        IEntityInstantiator<?, ?> instantiator = this.getInstantiator();
        if (instantiator != null && (oid = TypeUtils.toObject((JavaTypeDesc)JavaTypeRegistry.getType((Class)instantiator.getIdType()), (Object)id)) != null) {
            return (T)instantiator.find(em, oid);
        }
        List<BeanPropertyDesc> idFields = this.getIDFields();
        if (idFields.size() != 1) {
            return null;
        }
        BeanPropertyDesc idField = idFields.get(0);
        EntityPropertyExt idEntityField = (EntityPropertyExt)idField.getExtension(EntityPropertyExt.class);
        if (idEntityField == null) {
            return null;
        }
        if (!idEntityField.isSimpleId()) {
            return null;
        }
        Object idObj = null;
        if (idField.getType() instanceof BeanTypeDesc && (idEntityExt = (EntityTypeExt)((BeanTypeDesc)idField.getType()).getExtension(EntityTypeExt.class)) != null) {
            idObj = idEntityExt.get(em, id);
        }
        if (idObj == null) {
            idObj = TypeUtils.toObject((JavaTypeDesc)idField.getType(), (Object)id);
        }
        if (idObj == null) {
            return null;
        }
        return (T)em.find(this.type.getType(), idObj);
    }

    public static String[] getEntities() {
        ArrayList<String> ret = new ArrayList<String>();
        int size = 0;
        while (size != entityMap.size()) {
            size = entityMap.size();
            ret.clear();
            for (BeanTypeDesc<?> v : new ArrayList(entityMap.values())) {
                EntityTypeExt ee = (EntityTypeExt)v.getExtension(EntityTypeExt.class);
                if (ee.isMappedSuperclass()) continue;
                ret.add(ee.getEntityName());
            }
        }
        return ret.toArray(new String[ret.size()]);
    }
}

