/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.typeutils;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import net.inveed.typeutils.BeanPropertyDesc;
import net.inveed.typeutils.ext.IBeanPropertyExtension;

public class EntityPropertyExt
implements IBeanPropertyExtension {
    private final BeanPropertyDesc property;
    private Boolean isId;
    private Boolean isSimpleId;

    protected EntityPropertyExt(BeanPropertyDesc property) {
        this.property = property;
    }

    private void initializeEntityPropertyDesc() {
        Id idAnnotation = (Id)this.property.getAnnotation(Id.class);
        EmbeddedId eidAnnotation = (EmbeddedId)this.property.getAnnotation(EmbeddedId.class);
        this.isId = idAnnotation != null || eidAnnotation != null;
        this.isSimpleId = idAnnotation != null && eidAnnotation == null;
    }

    public boolean isId() {
        if (this.isId == null || this.isSimpleId == null) {
            this.initializeEntityPropertyDesc();
        }
        return this.isId;
    }

    public boolean isSimpleId() {
        if (this.isId == null || this.isSimpleId == null) {
            this.initializeEntityPropertyDesc();
        }
        return this.isSimpleId;
    }

    public boolean canGet() {
        return true;
    }

    public boolean canSet() {
        if (this.property.getAnnotation(Id.class) != null) {
            return false;
        }
        Column ca = (Column)this.property.getAnnotation(Column.class);
        if (ca != null && !ca.updatable()) {
            return false;
        }
        ManyToOne ma = (ManyToOne)this.property.getAnnotation(ManyToOne.class);
        if (ma != null) {
            JoinColumn ja = (JoinColumn)this.property.getAnnotation(JoinColumn.class);
            if (ja != null) {
                return ja.updatable();
            }
            JoinColumns jcsa = (JoinColumns)this.property.getAnnotation(JoinColumns.class);
            if (jcsa == null) {
                return false;
            }
            for (JoinColumn jc : jcsa.value()) {
                if (jc.updatable()) continue;
                return false;
            }
        }
        return true;
    }
}

