/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.jackson;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.persistence.EntityManager;
import net.inveed.rest.jpa.jackson.EntityBeadDeserializerModifier;
import net.inveed.rest.jpa.jackson.EntityBeanSerializerModifier;
import net.inveed.rest.jpa.jackson.EntitySerializationPropertyFilter;

public class JsonConfiguration {
    private ObjectMapper objectMapper;
    private static final ThreadLocal<Ctx> ctxLocal = new ThreadLocal();
    private static final ThreadLocal<SerializationTheadLocal> slocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getMapper() {
        if (this.objectMapper != null) {
            return this.objectMapper;
        }
        JsonConfiguration jsonConfiguration = this;
        synchronized (jsonConfiguration) {
            if (this.objectMapper != null) {
                return this.objectMapper;
            }
            this.objectMapper = new ObjectMapper();
            this.objectMapper.addMixIn(Object.class, PropertyFilterMixIn.class);
            this.objectMapper.registerModule(new Module(){

                public String getModuleName() {
                    return "inveed-jpa-rest";
                }

                public Version version() {
                    return Version.unknownVersion();
                }

                public void setupModule(Module.SetupContext context) {
                    context.addBeanSerializerModifier((BeanSerializerModifier)new EntityBeanSerializerModifier());
                    context.addBeanDeserializerModifier((BeanDeserializerModifier)new EntityBeadDeserializerModifier());
                }
            });
            EntitySerializationPropertyFilter serFilter = new EntitySerializationPropertyFilter();
            SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("serFilter", (SimpleBeanPropertyFilter)serFilter);
            this.objectMapper.setFilterProvider((FilterProvider)filters);
        }
        return this.objectMapper;
    }

    public static final EntityManager getContextEntityManager() {
        Ctx ctx = ctxLocal.get();
        if (ctx == null) {
            return null;
        }
        return ctx.em;
    }

    public static final SerializationTheadLocal getSerializationContext() {
        SerializationTheadLocal ret = slocal.get();
        if (ret == null) {
            ret = new SerializationTheadLocal();
            slocal.set(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(Object value, int deep) throws JsonGenerationException, JsonMappingException, IOException {
        SerializationTheadLocal tl = new SerializationTheadLocal();
        tl.deep = deep;
        tl.currentLevel = 0;
        slocal.set(tl);
        try {
            StringWriter w = new StringWriter();
            this.getMapper().writer().writeValue((Writer)w, value);
            String string = w.toString();
            return string;
        }
        finally {
            slocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode serializeToNode(Object value, int deep) {
        SerializationTheadLocal tl = new SerializationTheadLocal();
        tl.deep = deep;
        tl.currentLevel = 0;
        slocal.set(tl);
        try {
            JsonNode jsonNode = this.getMapper().valueToTree(value);
            return jsonNode;
        }
        finally {
            slocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(EntityManager em, String json, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        Ctx ctx = new Ctx();
        ctx.em = em;
        ctxLocal.set(ctx);
        try {
            Object object = this.getMapper().readValue(json, type);
            return (T)object;
        }
        finally {
            ctxLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(EntityManager em, String json, T target) throws JsonParseException, JsonMappingException, IOException {
        Ctx ctx = new Ctx();
        ctx.em = em;
        ctxLocal.set(ctx);
        try {
            Object object = this.getMapper().readerForUpdating(target).readValue(json);
            return (T)object;
        }
        finally {
            ctxLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(EntityManager em, JsonParser jsonParser, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        Ctx ctx = new Ctx();
        ctx.em = em;
        ctxLocal.set(ctx);
        try {
            Object object = this.getMapper().readValue(jsonParser, type);
            return (T)object;
        }
        finally {
            ctxLocal.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(EntityManager em, JsonParser jsonParser, T target) throws JsonParseException, JsonMappingException, IOException {
        Ctx ctx = new Ctx();
        ctx.em = em;
        ctxLocal.set(ctx);
        try {
            Object object = this.getMapper().readerForUpdating(target).readValue(jsonParser);
            return (T)object;
        }
        finally {
            ctxLocal.remove();
        }
    }

    @JsonFilter(value="serFilter")
    class PropertyFilterMixIn {
        PropertyFilterMixIn() {
        }
    }

    public static class SerializationTheadLocal {
        public int deep;
        public int currentLevel;
    }

    private static class Ctx {
        EntityManager em;

        private Ctx() {
        }
    }
}

