/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import java.io.IOException;
import java.util.Set;
import net.inveed.rest.jpa.annotations.TypeDescriminator;
import net.inveed.rest.jpa.annotations.TypeDescriminatorField;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import org.hibernate.proxy.HibernateProxy;

public class EntitySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = -9035067749825063337L;

    EntitySerializer(BeanSerializerBase source) {
        super(source);
    }

    EntitySerializer(EntitySerializer source, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)source, objectIdWriter);
    }

    EntitySerializer(EntitySerializer source, Set<String> toIgnore) {
        super((BeanSerializerBase)source, toIgnore);
    }

    public EntitySerializer(EntitySerializer source, ObjectIdWriter objectIdWriter, Object filterId) {
        super((BeanSerializerBase)source, objectIdWriter, filterId);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new EntitySerializer(this, objectIdWriter);
    }

    protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
        return new EntitySerializer(this, toIgnore);
    }

    protected BeanSerializerBase asArraySerializer() {
        return new BeanAsArraySerializer((BeanSerializerBase)this);
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        return new EntitySerializer(this, this._objectIdWriter, filterId);
    }

    private String getTypeDescriminatorFieldName(BeanTypeDesc<?> btd) {
        EntityTypeExt ete;
        BeanTypeDesc root = btd;
        while (btd != null && (ete = (EntityTypeExt)btd.getExtension(EntityTypeExt.class)) != null) {
            root = btd;
            btd = btd.getSupertype();
        }
        TypeDescriminatorField a = (TypeDescriminatorField)root.getDeclaredAnnotation(TypeDescriminatorField.class);
        if (a == null) {
            return "#type";
        }
        return a.value();
    }

    private String getTypeDescriminator(BeanTypeDesc<?> btd, EntityTypeExt<?> ete) {
        TypeDescriminator a = (TypeDescriminator)btd.getDeclaredAnnotation(TypeDescriminator.class);
        if (a == null) {
            return ete.getEntityName();
        }
        return a.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        JsonConfiguration.SerializationTheadLocal ctx = null;
        try {
            BeanTypeDesc btd;
            EntityTypeExt ete;
            if (this._objectIdWriter != null) {
                gen.setCurrentValue(bean);
                this._serializeWithObjectId(bean, gen, provider, true);
                return;
            }
            if (bean == null) {
                gen.writeNull();
                return;
            }
            Class entityType = bean.getClass();
            if (bean instanceof HibernateProxy) {
                entityType = ((HibernateProxy)bean).getHibernateLazyInitializer().getPersistentClass();
                bean = ((HibernateProxy)bean).getHibernateLazyInitializer().getImplementation();
            }
            String descField = null;
            String desc = null;
            JavaTypeDesc et = JavaTypeRegistry.getType((Class)entityType);
            if (et != null && et instanceof BeanTypeDesc && (ete = (EntityTypeExt)(btd = (BeanTypeDesc)et).getExtension(EntityTypeExt.class)) != null) {
                ctx = JsonConfiguration.getSerializationContext();
                ++ctx.currentLevel;
                descField = this.getTypeDescriminatorFieldName(btd);
                desc = this.getTypeDescriminator(btd, ete);
            }
            gen.writeStartObject(bean);
            if (this._propertyFilterId != null) {
                this.serializeFieldsFiltered(bean, gen, provider);
            } else {
                this.serializeFields(bean, gen, provider);
            }
            if (desc != null) {
                gen.writeStringField(descField, desc);
            }
            gen.writeEndObject();
        }
        finally {
            if (ctx != null) {
                --ctx.currentLevel;
            }
        }
    }
}

