/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.util.List;
import net.inveed.rest.jpa.IComplexIdEntity;
import net.inveed.rest.jpa.annotations.JsonEmbeddedEntity;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;
import net.inveed.rest.jpa.typeutils.JsonTypeExt;
import net.inveed.typeutils.BeanPropertyDesc;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializationPropertyFilter
extends SimpleBeanPropertyFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EntitySerializationPropertyFilter.class);

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        JavaTypeDesc pojoType = JavaTypeRegistry.getType(pojo.getClass());
        if (!(pojoType instanceof BeanTypeDesc)) {
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        BeanTypeDesc beanType = (BeanTypeDesc)pojoType;
        EntityTypeExt entityType = (EntityTypeExt)beanType.getExtension(EntityTypeExt.class);
        if (entityType == null) {
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        JsonTypeExt beanJsonExt = (JsonTypeExt)beanType.getExtension(JsonTypeExt.class);
        BeanPropertyDesc fld = beanJsonExt == null ? beanType.getProperty(writer.getName()) : beanJsonExt.getJSONProperty(writer.getName());
        if (fld == null) {
            LOG.warn("Cannot find property with name '{}' in type '{}'", (Object)writer.getName(), (Object)beanType.getFullName());
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        if (fld.getType().getExtension(EntityTypeExt.class) == null) {
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        Object value = fld.getValue(pojo);
        if (value == null) {
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        JsonConfiguration.SerializationTheadLocal ctx = JsonConfiguration.getSerializationContext();
        int deep = ctx.deep;
        JsonEmbeddedEntity jeea = (JsonEmbeddedEntity)fld.getAnnotation(JsonEmbeddedEntity.class);
        if (jeea != null) {
            deep = Math.max(jeea.deep(), deep);
            LOG.debug("Found JsonEmbeddedEntity annotation for property '{}' with deep {}. Effective deep: {}", new Object[]{fld.getName(), jeea.deep(), deep});
        }
        if (ctx.currentLevel <= deep) {
            LOG.debug("Serializing entity '{}' in '{}' property '{}' as POJO because of requested nesting level {} (current level is {})", new Object[]{fld.getType().getType().getName(), beanType.getFullName(), fld.getName(), deep, ctx.currentLevel - 1});
            super.serializeAsField(pojo, jgen, provider, writer);
            return;
        }
        this.serializeEntityId(pojo, value, entityType, (EntityTypeExt)fld.getType().getExtension(EntityTypeExt.class), jgen, provider, writer);
    }

    protected void serializeEntityId(Object pojo, Object value, EntityTypeExt<?> entityType, EntityTypeExt<?> fieldType, JsonGenerator gen, SerializerProvider provider, PropertyWriter writer) throws Exception {
        if (value instanceof IComplexIdEntity) {
            LOG.debug("Serializing as ComplexID value");
            IComplexIdEntity cie = (IComplexIdEntity)value;
            gen.writeFieldName(writer.getName());
            gen.writeObject((Object)cie.getComplexId());
            return;
        }
        List<BeanPropertyDesc> idFields = fieldType.getIDFields();
        if (idFields == null || idFields.size() < 1) {
            LOG.warn("Cannot find ID fields for entity {}", (Object)entityType.getEntityName());
            super.serializeAsField(pojo, gen, provider, writer);
            return;
        }
        if (idFields.size() == 1) {
            gen.writeFieldName(writer.getName());
            gen.writeObject(idFields.get(0).getValue(value));
            return;
        }
        gen.writeFieldName(writer.getName());
        gen.writeStartObject();
        for (BeanPropertyDesc bpd : idFields) {
            gen.writeFieldName(bpd.getName());
            gen.writeObject(bpd.getValue(value));
        }
        gen.writeEndObject();
        LOG.warn("Multiple IDs are not supported for entity {}. Serializing as POJO.", (Object)entityType.getEntityName());
        super.serializeAsField(pojo, gen, provider, writer);
    }
}

