/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.rest.jpa.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import java.io.IOException;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import net.inveed.rest.jpa.IEntityInstantiator;
import net.inveed.rest.jpa.JsonTypeUtils;
import net.inveed.rest.jpa.jackson.JsonConfiguration;
import net.inveed.rest.jpa.jackson.JsonEntityNotFoundException;
import net.inveed.rest.jpa.typeutils.EntityTypeExt;
import net.inveed.typeutils.BeanPropertyDesc;
import net.inveed.typeutils.BeanTypeDesc;
import net.inveed.typeutils.JavaTypeDesc;
import net.inveed.typeutils.JavaTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDeserializer
extends JsonDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDeserializer.class);
    private BeanProperty property;
    private JsonDeserializer<?> parent;

    public EntityDeserializer(JsonDeserializer<?> parent, DeserializationConfig config, BeanDescription beanDesc) {
        this.parent = parent;
    }

    public EntityDeserializer(BeanProperty property, JsonDeserializer<?> parent) {
        this.property = property;
        this.parent = parent;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this.property == null || this.property.getType() == null) {
            LOG.warn("Something went wrong. Trying to deserialize without context.");
            return this.parent.deserialize(p, ctxt);
        }
        JavaTypeDesc et = JavaTypeRegistry.getType((Class)this.property.getType().getRawClass());
        if (et == null) {
            LOG.warn("Something went wrong. Cannot find type for property type {}.", (Object)this.property.getType().getRawClass());
            return this.parent.deserialize(p, ctxt);
        }
        if (et instanceof BeanTypeDesc) {
            BeanTypeDesc btd = (BeanTypeDesc)et;
            EntityTypeExt ete = (EntityTypeExt)btd.getExtension(EntityTypeExt.class);
            if (ete == null) {
                LOG.debug("Deserializing bean type {}", (Object)et.getType());
                return this.parent.deserialize(p, ctxt);
            }
            LOG.debug("Deserializing entity type {}", (Object)et.getType());
            return this.deserialize(p, ctxt, ete);
        }
        LOG.debug("Deserializing simple type {}", (Object)et.getType());
        return this.parent.deserialize(p, ctxt);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, EntityTypeExt<?> type) throws IOException, JsonProcessingException {
        if (p.getCurrentToken() == JsonToken.START_OBJECT) {
            LOG.warn("Complex ID types not implemented");
            return this.parent.deserialize(p, ctxt);
        }
        IEntityInstantiator<?, ?> ei = type.getInstantiator();
        if (ei != null) {
            LOG.debug("Trying to use instantiator {}", ei.getClass());
            Class idType = ei.getIdType();
            JavaTypeDesc fieldType = JavaTypeRegistry.getType((Class)idType);
            Object idObject = JsonTypeUtils.getPrimitive(fieldType, p);
            if (idObject == null) {
                LOG.warn("Cannot read complex ID object with type ", (Object)fieldType.getType());
                throw new JsonEntityNotFoundException(ei.getClass(), idObject);
            }
            LOG.debug("Instantiating entity {} with ID '{}'", (Object)type.getEntityName(), idObject);
            try {
                Object ret = ei.find(JsonConfiguration.getContextEntityManager(), idObject);
                if (ret == null) {
                    LOG.warn("Cannot find entity with instantiator. Complex ID is {}", idObject);
                    throw new JsonEntityNotFoundException(ei.getClass(), idObject);
                }
                return ret;
            }
            catch (EntityNotFoundException e) {
                LOG.warn("Cannot find entity with instantiator (exception handled). Complex ID is {}", idObject);
                throw new JsonEntityNotFoundException(ei.getClass(), idObject);
            }
        }
        List<BeanPropertyDesc> idFields = type.getIDFields();
        if (idFields == null || idFields.size() < 1) {
            LOG.warn("Cannot determine ID fields for type ", (Object)type.getBeanType().getType());
            throw new JsonEntityNotFoundException(type.getBeanType().getType(), null);
        }
        if (idFields.size() > 1) {
            LOG.warn("Multiple fields in ID not implemented");
            throw new JsonEntityNotFoundException(type.getBeanType().getType(), null);
        }
        JavaTypeDesc fieldType = idFields.get(0).getType();
        Object idObject = JsonTypeUtils.getPrimitive(fieldType, p);
        if (idObject == null) {
            LOG.warn("Cannot read ID object with type ", (Object)fieldType.getType());
            throw new JsonEntityNotFoundException(type.getBeanType().getType(), null);
        }
        LOG.debug("Searching for entity {} with ID '{}'", (Object)type.getEntityName(), idObject);
        try {
            Object ret = JsonConfiguration.getContextEntityManager().find(this.property.getType().getRawClass(), idObject);
            if (ret == null) {
                throw new JsonEntityNotFoundException(type.getBeanType().getType(), idObject);
            }
            return ret;
        }
        catch (EntityNotFoundException e) {
            throw new JsonEntityNotFoundException(type.getBeanType().getType(), idObject);
        }
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return this.parent;
        }
        if (this.property != null && EntityDeserializer.isPropEqual(this.property, property)) {
            return this;
        }
        return new EntityDeserializer(property, this.parent);
    }

    private static final boolean isPropEqual(BeanProperty bp1, BeanProperty bp2) {
        if (!bp1.getName().equals(bp2.getName())) {
            return false;
        }
        return bp1.getType().equals((Object)bp2.getType());
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        if (this.parent instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)this.parent).resolve(ctxt);
        }
    }
}

