/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.utils;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import net.inveed.gwt.editor.client.auth.AuthHelper;
import net.inveed.gwt.editor.client.utils.JsHttpClient;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.PromiseImpl;

public class JsHttpRequest {
    private String url;
    private boolean authenticate;
    private String data;
    private RequestBuilder.Method method;

    public JsHttpRequest(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isAuthenticate() {
        return this.authenticate;
    }

    public void setAuthenticate(boolean authenticate) {
        this.authenticate = authenticate;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public RequestBuilder.Method getMethod() {
        return this.method;
    }

    public void setMethod(RequestBuilder.Method method) {
        this.method = method;
    }

    private static final void addAuthHeader(RequestBuilder builder) {
        if (AuthHelper.INSTANCE.getToken() == null) {
            return;
        }
        builder.setHeader("X-Auth-Token", AuthHelper.INSTANCE.getToken());
    }

    private void processResonse(PromiseImpl<JsHttpClient.RequestResult, JsHttpClient.HTTPError> promise, Request request, Response response) {
        if (response.getStatusCode() == 401 && AuthHelper.INSTANCE.getAuthCallback() != null) {
            AuthHelper.INSTANCE.getAuthCallback().authenticate().thenApply(v -> {
                this.execute(promise);
                return null;
            }).onError((v, e) -> {
                promise.complete(new JsHttpClient.RequestResult(request, response));
                return null;
            });
        }
        promise.complete(new JsHttpClient.RequestResult(request, response));
    }

    public Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> execute() {
        PromiseImpl<JsHttpClient.RequestResult, JsHttpClient.HTTPError> ret = new PromiseImpl<JsHttpClient.RequestResult, JsHttpClient.HTTPError>();
        this.execute(ret);
        return ret;
    }

    private void execute(final PromiseImpl<JsHttpClient.RequestResult, JsHttpClient.HTTPError> promise) {
        RequestBuilder builder = new RequestBuilder(this.getMethod(), this.getUrl());
        if (this.isAuthenticate()) {
            JsHttpRequest.addAuthHeader(builder);
        }
        try {
            builder.sendRequest(this.getData(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    promise.error(new JsHttpClient.HTTPError(request), exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    JsHttpRequest.this.processResonse(promise, request, response);
                }
            });
        }
        catch (RequestException e) {
            promise.error(null, null);
        }
    }
}

