/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.types;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.Date;
import net.inveed.gwt.editor.client.types.IJSObject;

public class JSTimestamp
implements IJSObject {
    public static final String TYPE = "TIMESTAMP";
    private Date value;
    private DateTimeFormat jsonFormat;

    public static JSTimestamp parse(String v, DateTimeFormat fmt) {
        try {
            Double d = Double.parseDouble(v);
            if (d != null) {
                return JSTimestamp.parse((JSONValue)new JSONNumber(d.doubleValue()), fmt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSTimestamp.parse((JSONValue)new JSONString(v), fmt);
    }

    public static JSTimestamp parse(JSONValue json, DateTimeFormat fmt) {
        if (json.isString() != null) {
            String v = json.isString().stringValue();
            try {
                Date d = fmt.parse(v);
                if (d != null) {
                    return new JSTimestamp(d, fmt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        if (json.isNumber() != null) {
            return new JSTimestamp(new Date((long)(json.isNumber().doubleValue() * 1000.0)), null);
        }
        return null;
    }

    public JSTimestamp(Date date, DateTimeFormat jsonFormat) {
        if (date == null) {
            throw new NullPointerException("date cannot be null");
        }
        this.value = date;
        this.jsonFormat = jsonFormat;
    }

    @Override
    public int compareTo(IJSObject other) {
        if (other.getType() != TYPE) {
            return TYPE.compareTo(other.getType());
        }
        JSTimestamp od = (JSTimestamp)other;
        return this.value.compareTo(od.value);
    }

    @Override
    public boolean isEquals(IJSObject other) {
        if (other == null) {
            return false;
        }
        if (other.getType() != this.getType()) {
            return false;
        }
        return ((JSTimestamp)other).value.equals(this.value);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Date getValue() {
        return this.value;
    }

    @Override
    public JSONValue getJSONValue() {
        if (this.jsonFormat == null) {
            return new JSONNumber((double)this.value.getTime() / 1000.0);
        }
        return new JSONString(this.jsonFormat.format(this.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

