/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.types;

import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import net.inveed.gwt.editor.client.types.IJSObject;

public class JSTimeInterval
implements IJSObject {
    public static final String TYPE = "TIME_INTERVAL";
    private static final long SEC_IN_DAY = 86400L;
    private static final long SEC_IN_HOUR = 3600L;
    private final int months;
    private final double seconds;
    private final Format jsonFormat;

    public static final JSTimeInterval parse(String v, Format format) {
        if (v == null) {
            return null;
        }
        try {
            Double d = Double.parseDouble(v);
            if (d != null) {
                return JSTimeInterval.parse((JSONValue)new JSONNumber(d.doubleValue()), format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSTimeInterval.parse((JSONValue)new JSONString(v), format);
    }

    public static final JSTimeInterval parse(JSONValue json, Format format) {
        if (json.isNull() != null) {
            return null;
        }
        if (json.isNumber() != null) {
            if (format == Format.MSECONDS) {
                return new JSTimeInterval(0, json.isNumber().doubleValue() / 1000.0, format);
            }
            if (format == Format.SECONDS) {
                return new JSTimeInterval(0, json.isNumber().doubleValue(), format);
            }
            if (format == Format.MINUTES) {
                return new JSTimeInterval(0, json.isNumber().doubleValue() * 60.0, format);
            }
            return null;
        }
        if (json.isString() != null) {
            String sv = json.isString().stringValue();
            if (format == Format.ISO) {
                return null;
            }
            try {
                double dv = Double.parseDouble(sv);
                if (format == Format.MSECONDS) {
                    return new JSTimeInterval(0, dv / 1000.0, format);
                }
                if (format == Format.SECONDS) {
                    return new JSTimeInterval(0, dv, format);
                }
                if (format == Format.MINUTES) {
                    return new JSTimeInterval(0, dv * 60.0, format);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public JSTimeInterval(Integer years, Integer months, Integer days, Integer hours, Integer minutes, Double seconds, Format format) {
        int y = years == null ? 0 : years;
        int M = months == null ? 0 : months;
        long d = days == null ? 0L : (long)days.intValue();
        long h = hours == null ? 0L : (long)hours.intValue();
        long m = minutes == null ? 0L : (long)minutes.intValue();
        double s = seconds == null ? 0.0 : seconds;
        this.months = y * 12 + M;
        this.seconds = (double)(d * 86400L + h * 3600L + m * 60L) + s;
        this.jsonFormat = format;
    }

    public JSTimeInterval(int months, double seconds, Format format) {
        this.months = months;
        this.seconds = seconds;
        this.jsonFormat = format;
    }

    @Override
    public boolean isEquals(IJSObject other) {
        if (other == null) {
            return false;
        }
        if (other.getType() != this.getType()) {
            return false;
        }
        JSTimeInterval oi = (JSTimeInterval)other;
        return oi.months == this.months && oi.seconds == this.seconds;
    }

    @Override
    public int compareTo(IJSObject other) {
        if (other == null) {
            return -1;
        }
        if (other.getType() != TYPE) {
            return TYPE.compareTo(other.getType());
        }
        JSTimeInterval o = (JSTimeInterval)other;
        int ret = Integer.compare(this.months, o.months);
        if (ret != 0) {
            return ret;
        }
        ret = Double.compare(this.seconds, o.seconds);
        return ret;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public int getMonths() {
        return this.months;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getHYears() {
        return this.getMonths() / 12;
    }

    public int getHMonths() {
        int years = this.getHYears();
        return this.getMonths() - years * 12;
    }

    public long getHDays() {
        return (long)this.getSeconds() / 86400L;
    }

    public long getHHours() {
        long days = this.getHDays();
        long lsec = (long)this.getSeconds() - days * 86400L;
        return lsec / 3600L;
    }

    public long getHMinutes() {
        long days = this.getHDays();
        long hours = this.getHHours();
        long lsec = (long)this.getSeconds() - days * 86400L - hours * 3600L;
        return lsec / 60L;
    }

    public double getHSeconds() {
        long days = this.getHDays();
        long hours = this.getHHours();
        long minutes = this.getHMinutes();
        return this.getSeconds() - (double)(days * 86400L + hours * 3600L + minutes * 60L);
    }

    @Override
    public JSONValue getJSONValue() {
        if (this.months != 0 || this.jsonFormat == Format.ISO) {
            return new JSONString(this.toISOString());
        }
        if (this.jsonFormat == Format.SECONDS) {
            return new JSONNumber(this.seconds);
        }
        if (this.jsonFormat == Format.MSECONDS) {
            return new JSONNumber((double)((long)(this.seconds * 1000.0)));
        }
        if (this.jsonFormat == Format.MINUTES) {
            return new JSONNumber((double)((long)(this.seconds / 60.0)));
        }
        return JSONNull.getInstance();
    }

    public String toISOString() {
        StringBuffer sb = new StringBuffer();
        sb.append("P");
        int y = this.getHYears();
        int M = this.getHMonths();
        long d = this.getHDays();
        long h = this.getHHours();
        long m = this.getHMinutes();
        double s = this.getHSeconds();
        if (y != 0) {
            sb.append(y);
            sb.append("Y");
        }
        if (M != 0) {
            sb.append(M);
            sb.append("M");
        }
        if (d != 0L) {
            sb.append(d);
            sb.append("D");
        }
        sb.append("T");
        if (h != 0L) {
            sb.append(h);
            sb.append("H");
        }
        if (m != 0L) {
            sb.append(m);
            sb.append("M");
        }
        if (s != 0.0) {
            sb.append(s);
            sb.append("S");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int y = this.getHYears();
        int M = this.getHMonths();
        long d = this.getHDays();
        long h = this.getHHours();
        long m = this.getHMinutes();
        double s = this.getHSeconds();
        if (y != 0) {
            sb.append(y);
            sb.append(" Years ");
        }
        if (M != 0) {
            sb.append(M);
            sb.append(" Months ");
        }
        if (d != 0L) {
            sb.append(d);
            sb.append(" Days ");
        }
        if (h != 0L) {
            sb.append(h);
            sb.append(" Hours ");
        }
        if (m != 0L) {
            sb.append(m);
            sb.append(" Minutes ");
        }
        if (s != 0.0) {
            sb.append(s);
            sb.append(" Seconds ");
        }
        return sb.toString().trim();
    }

    public static enum Format {
        ISO,
        MINUTES,
        SECONDS,
        MSECONDS;

    }
}

