/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.model.properties;

import com.google.gwt.json.client.JSONValue;
import net.inveed.gwt.editor.client.editor.fields.EnumItemSelector;
import net.inveed.gwt.editor.client.model.ConfigurationRegistry;
import net.inveed.gwt.editor.client.model.EntityManager;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.AbstractPropertyModel;
import net.inveed.gwt.editor.client.types.enums.EnumModel;
import net.inveed.gwt.editor.shared.FieldType;
import net.inveed.gwt.editor.shared.PropertyModelDTO;

public class EnumPropertyModel
extends AbstractPropertyModel<EnumModel.JSEnumValue> {
    private final EnumModel enumModel;
    private EnumModel.JSEnumValue defaultValue;

    public EnumPropertyModel(PropertyModelDTO field, String name, EntityModel entity) {
        super(field, name, entity);
        if (field.type != FieldType.ENUM) {
            // empty if block
        }
        this.enumModel = ConfigurationRegistry.INSTANCE.getEnum(field.attributes.referencedEnumName);
        if (this.enumModel == null) {
            // empty if block
        }
        this.defaultValue = this.enumModel.getByCode(field.defaultValue);
    }

    public EnumModel getEnumModel() {
        return this.enumModel;
    }

    public EnumItemSelector createEditor() {
        return new EnumItemSelector();
    }

    @Override
    public EnumModel.JSEnumValue convertToJSObject(JSONValue v, EntityManager em) {
        if (v.isString() != null) {
            return this.enumModel.getByCode(v.isString().stringValue());
        }
        return null;
    }

    @Override
    public EnumModel.JSEnumValue getRawValue(JSEntity entity) {
        return (EnumModel.JSEnumValue)entity.getProperty(this.getName(), "ENUM");
    }

    @Override
    public EnumModel.JSEnumValue getDefaultValue() {
        return this.defaultValue;
    }
}

