/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.model.properties;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.cellview.client.Column;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.inveed.gwt.editor.client.editor.fields.EntityRefListBoxSelector;
import net.inveed.gwt.editor.client.lists.EntityReferenceCell;
import net.inveed.gwt.editor.client.model.ConfigurationRegistry;
import net.inveed.gwt.editor.client.model.EntityManager;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.AbstractPropertyModel;
import net.inveed.gwt.editor.client.model.properties.IPropertyDesc;
import net.inveed.gwt.editor.client.types.IJSObject;
import net.inveed.gwt.editor.shared.FieldType;
import net.inveed.gwt.editor.shared.PropertyModelDTO;

public class EntityReferencePropertyModel
extends AbstractPropertyModel<JSEntity> {
    private final EntityModel targetModel;
    private Map<String, String> filters;

    public EntityReferencePropertyModel(PropertyModelDTO field, String name, EntityModel entity) {
        super(field, name, entity);
        if (field.type != FieldType.OBJECT_REF) {
            // empty if block
        }
        this.targetModel = ConfigurationRegistry.INSTANCE.getModel(field.attributes.referencedEntityName);
        if (this.targetModel == null) {
            // empty if block
        }
        this.filters = field.filters != null ? Collections.unmodifiableMap(field.filters) : Collections.unmodifiableMap(new HashMap());
    }

    public EntityModel getTargetEntityModel() {
        return this.targetModel;
    }

    public EntityRefListBoxSelector createEditor() {
        return new EntityRefListBoxSelector();
    }

    @Override
    public JSEntity convertToJSObject(JSONValue entityJson, EntityManager em) {
        if (entityJson == null) {
            return null;
        }
        if (entityJson.isObject() != null) {
            JSEntity ret = em.get(this.targetModel, entityJson.isObject());
            return ret;
        }
        if (this.getTargetEntityModel().getIdFields().size() == 0) {
            return null;
        }
        if (this.getTargetEntityModel().getIdFields().size() == 1) {
            IPropertyDesc<?> idProp = this.getTargetEntityModel().getIdFields().get(0);
            Object idObj = idProp.convertToJSObject(entityJson, em);
            return em.get(idProp.getEntityModelWrapper(), (IJSObject)idObj);
        }
        return null;
    }

    @Override
    public JSEntity getRawValue(JSEntity entity) {
        return (JSEntity)entity.getProperty(this.getName(), "ENTITY");
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    @Override
    public Column<JSEntity, ?> createTableColumn() {
        EntityReferenceCell cell = new EntityReferenceCell();
        Column<JSEntity, JSEntity> ret = new Column<JSEntity, JSEntity>((Cell)cell){

            public JSEntity getValue(JSEntity row) {
                return EntityReferencePropertyModel.this.getRawValue(row);
            }
        };
        return ret;
    }

    @Override
    public JSEntity getDefaultValue() {
        return null;
    }
}

