/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.model;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCRequest;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCTransaction;
import net.inveed.gwt.editor.client.model.EntityManager;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.properties.IPropertyDesc;
import net.inveed.gwt.editor.client.types.IJSObject;
import net.inveed.gwt.editor.client.types.JSMap;
import net.inveed.gwt.editor.client.types.JSString;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.PromiseImpl;
import net.inveed.gwt.editor.shared.FieldType;

public class JSEntity
implements IJSObject {
    public static final String TYPE = "ENTITY";
    private EntityModel type;
    private JSMap<IJSObject> commitedProperties = new JSMap();
    private JSMap<IJSObject> modifiedProperties = new JSMap();
    private boolean initialized;
    private IJSObject id;
    private boolean isDeleted;
    private String displayValue;
    private final EntityManager entityManager;

    public JSEntity(EntityModel type, EntityManager em) {
        this.entityManager = em;
        this.type = type;
        this.initialized = false;
    }

    public JSEntity(EntityModel type, IJSObject id, EntityManager em) {
        this.entityManager = em;
        this.type = type;
        this.id = id;
        this.initialized = false;
    }

    public JSEntity(EntityModel model, JSONObject json, EntityManager em) {
        this.entityManager = em;
        this.type = model;
        this.id = model.getEntityID(json, em);
        this.updateFromJson(json);
    }

    @Override
    public boolean isEquals(IJSObject other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        JSEntity oe = (JSEntity)other;
        if (oe.getID() == null || this.getID() == null) {
            return false;
        }
        return oe.getID().isEquals(this.getID());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public IJSObject getID() {
        return this.id;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public EntityModel getModel() {
        return this.type;
    }

    public IJSObject getProperty(String name, String type) {
        IJSObject ret = this.getProperty(name);
        if (ret == null) {
            return ret;
        }
        if (ret.getType().equals(type)) {
            return ret;
        }
        return null;
    }

    public IJSObject getProperty(String name) {
        if (name == null) {
            return null;
        }
        if (this.modifiedProperties.containsKey(name = name.trim())) {
            return (IJSObject)this.modifiedProperties.get(name);
        }
        return (IJSObject)this.commitedProperties.get(name);
    }

    public IJSObject getCommitedProperty(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        return (IJSObject)this.commitedProperties.get(name);
    }

    public void setProperty(String name, IJSObject v) {
        IJSObject cv = (IJSObject)this.commitedProperties.get(name);
        if (cv == v) {
            this.modifiedProperties.remove(name);
            return;
        }
        if (cv != null && cv.equals(v)) {
            this.modifiedProperties.remove(name);
            return;
        }
        this.modifiedProperties.put(name, v);
    }

    private String getDisplayValue(JSONObject entity) {
        List<IPropertyDesc<?>> nameFields = this.getModel().getNameProperties();
        if (nameFields != null && nameFields.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (IPropertyDesc<?> pd : this.getModel().getNameProperties()) {
                Object pv = pd.getValue(entity, this.getEntityManager());
                sb.append(pv.toString());
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return this.getModel().getDisplayName(null) + "# " + this.id.toString();
    }

    void updateFromJson(JSONObject json) {
        boolean hasOnlyID = true;
        EntityModel newModel = this.getModel().getEntityType(json);
        if (newModel != null && newModel.isParentType(this.getModel())) {
            this.type = newModel;
        }
        for (IPropertyDesc<?> prop : this.getModel().getFields()) {
            try {
                JSONValue jv = prop.getValue(json);
                if (jv.isNull() != null) continue;
                this.commitedProperties.put(prop.getName(), (IJSObject)prop.getValue(json, this.getEntityManager()));
                if (prop.getType() == FieldType.ID_INTEGER || prop.getType() == FieldType.ID_STRING) continue;
                hasOnlyID = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean bl = this.initialized = !hasOnlyID || this.initialized;
        if (this.id == null) {
            this.id = this.getModel().getEntityID(json, this.getEntityManager());
        }
        this.displayValue = this.getDisplayValue(json);
        this.modifiedProperties = new JSMap();
    }

    public void save(JsonRPCTransaction tran) {
        JsonRPCRequest req = this.getID() == null ? this.createCreateRequest() : this.createUpdateRequest();
        tran.add(req);
        Promise<JSONValue, IError> p = req.getPromise();
        p.thenApply(v -> {
            if (v == null) {
                return null;
            }
            if (v.isObject() == null) {
                return null;
            }
            this.updateFromJson(v.isObject());
            return null;
        });
    }

    private JsonRPCRequest createCreateRequest() {
        String td;
        Object data = this.modifiedProperties.clone();
        HashMap<String, JSONValue> params = new HashMap<String, JSONValue>();
        Map<String, String> createArgNames = this.getModel().getServiceCreateArgs();
        if (createArgNames != null && createArgNames.size() > 0) {
            for (String carg : createArgNames.keySet()) {
                String cname = createArgNames.get(carg);
                if (!((HashMap)data).containsKey(cname)) {
                    return null;
                }
                IJSObject v = (IJSObject)((HashMap)data).get(cname);
                params.put(carg, v.getJSONValue());
                ((HashMap)data).remove(cname);
            }
        }
        if (this.getModel().getTypeDescriminator() != null && this.getModel().isRequiredTypeOnUpdate() && (td = this.getModel().getTypeDescriminator().trim()).length() > 0) {
            String tdf = this.getModel().getTypeDiscriminatorField();
            if (tdf == null) {
                tdf = "#type";
            }
            ((HashMap)data).put(tdf, new JSString(td));
        }
        params.put(this.getModel().getServiceArgData(), ((JSMap)data).getJSONValue());
        JsonRPCRequest ret = new JsonRPCRequest(this.getModel().getServiceName() + "#" + this.getModel().getServiceMethodCreate(), params);
        return ret;
    }

    private JsonRPCRequest createUpdateRequest() {
        HashMap<String, JSONValue> params = new HashMap<String, JSONValue>();
        params.put(this.getModel().getServiceArgId(), this.getID().getJSONValue());
        params.put(this.getModel().getServiceArgData(), this.modifiedProperties.getJSONValue());
        JsonRPCRequest ret = new JsonRPCRequest(this.getModel().getServiceName() + "#" + this.getModel().getServiceMethodUpdate(), params);
        return ret;
    }

    public Promise<Void, IError> load() {
        PromiseImpl<Void, IError> ret = new PromiseImpl<Void, IError>();
        HashMap<String, JSONValue> params = new HashMap<String, JSONValue>();
        params.put(this.getModel().getServiceArgId(), this.id.getJSONValue());
        Promise<JSONValue, IError> p = JsonRPCRequest.makeCall(this.getModel().getServiceName() + "#" + this.getModel().getServiceMethodGet(), params);
        p.thenApply(v -> {
            if (v == null) {
                ret.error(new JSEntityError(0), null);
            } else if (v.isObject() != null) {
                this.updateFromJson(v.isObject());
                ret.complete(null);
            } else {
                ret.error(new JSEntityError(0), null);
            }
            return null;
        });
        p.onError((err, t) -> {
            ret.error((IError)err, (Throwable)t);
            return null;
        });
        return ret;
    }

    public void delete(JsonRPCTransaction tran) {
        JsonRPCRequest req = this.createDeleteRequest();
        Promise<JSONValue, IError> p = req.getPromise();
        p.thenApply(v -> {
            this.entityManager.remove(this);
            this.id = null;
            this.isDeleted = true;
            return null;
        });
        tran.add(req);
    }

    private JsonRPCRequest createDeleteRequest() {
        HashMap<String, JSONValue> params = new HashMap<String, JSONValue>();
        params.put(this.getModel().getServiceArgId(), this.id.getJSONValue());
        JsonRPCRequest ret = new JsonRPCRequest(this.getModel().getServiceName() + "#" + this.getModel().getServiceMethodDelete(), params);
        ret.setContext(this);
        return ret;
    }

    @Override
    public int compareTo(IJSObject other) {
        if (other == null) {
            return 1;
        }
        if (!TYPE.equals(other.getType())) {
            return 0;
        }
        JSEntity e = (JSEntity)other;
        if (e.initialized) {
            return this.getDisplayValue().compareTo(e.getDisplayValue());
        }
        return e.getID().compareTo(this.getID());
    }

    @Override
    public JSONValue getJSONValue() {
        return this.id.getJSONValue();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean canDelete() {
        return this.getModel().canDelete();
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean canEdit() {
        return true;
    }

    public static final class JSEntityError
    implements IError {
        public static final String TYPE = "JSEntityError";
        public static final int ERR_EMPTY_ENTITY_RESPONSE = 0;
        public static final int ERR_INVALID_ENTITY_RESPONSE = 0;
        public static final int ERR_ENTITY_NOT_FOUND = 0;

        public JSEntityError(int code) {
        }

        @Override
        public String getMessage() {
            return null;
        }

        @Override
        public String getLocalizedMessage() {
            return null;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }
}

