/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.model;

import com.github.nmorel.gwtjackson.client.ObjectMapper;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.inveed.gwt.editor.client.i18n.Localizer;
import net.inveed.gwt.editor.client.model.ConfigurationRegistry;
import net.inveed.gwt.editor.client.model.EntityFormView;
import net.inveed.gwt.editor.client.model.EntityListView;
import net.inveed.gwt.editor.client.model.EntityManager;
import net.inveed.gwt.editor.client.model.properties.BooleanPropertyModel;
import net.inveed.gwt.editor.client.model.properties.DatePropertyModel;
import net.inveed.gwt.editor.client.model.properties.DurationPropertyModel;
import net.inveed.gwt.editor.client.model.properties.EntityReferencePropertyModel;
import net.inveed.gwt.editor.client.model.properties.EnumPropertyModel;
import net.inveed.gwt.editor.client.model.properties.FloatPropertyModel;
import net.inveed.gwt.editor.client.model.properties.IPropertyDesc;
import net.inveed.gwt.editor.client.model.properties.IntegerFieldModel;
import net.inveed.gwt.editor.client.model.properties.IntegerIDPropertyModel;
import net.inveed.gwt.editor.client.model.properties.LinkedEntitiesListPropertyModel;
import net.inveed.gwt.editor.client.model.properties.NetworkAddressPropertyModel;
import net.inveed.gwt.editor.client.model.properties.SecretFieldPropertyModel;
import net.inveed.gwt.editor.client.model.properties.StringIDPropertyModel;
import net.inveed.gwt.editor.client.model.properties.TextPropertyModel;
import net.inveed.gwt.editor.client.model.properties.TimestampPropertyModel;
import net.inveed.gwt.editor.client.types.IJSObject;
import net.inveed.gwt.editor.client.types.JSMap;
import net.inveed.gwt.editor.client.utils.JsonHelper;
import net.inveed.gwt.editor.shared.EntityEditorsDTO;
import net.inveed.gwt.editor.shared.EntityModelDTO;
import net.inveed.gwt.editor.shared.FieldType;
import net.inveed.gwt.editor.shared.PropertyModelDTO;

public final class EntityModel {
    private static final String I18N_PREFIX = "entities";
    private final EntityModelDTO nativeModel;
    private List<IPropertyDesc<?>> idProperties = new ArrayList();
    private List<IPropertyDesc<?>> nameProperties = new ArrayList();
    private List<IPropertyDesc<?>> allProperties;
    private List<IPropertyDesc<?>> declaredProperties;
    private HashMap<String, IPropertyDesc<?>> allPropertiesByName;
    private HashMap<String, EntityListView> listViews = new HashMap();
    private HashMap<String, EntityFormView> formViews = new HashMap();
    private HashMap<String, EntityModel> childModels = new HashMap();
    private HashMap<String, EntityModel> childModelsByDescriminator = new HashMap();
    private String discriminatorField;

    public EntityModel(EntityModelDTO model, ConfigurationRegistry registry) {
        this.nativeModel = model;
    }

    void initialize() {
        if (this.allProperties != null) {
            return;
        }
        HashMap nameProperties = new HashMap();
        ArrayList declaredProperties = new ArrayList();
        for (String fname : this.nativeModel.properties.keySet()) {
            PropertyModelDTO fm = (PropertyModelDTO)this.nativeModel.properties.get(fname);
            IPropertyDesc<?> fld = this.createPropertyDescriptor(fname, fm);
            declaredProperties.add(fld);
            if (fm.type == FieldType.ID_INTEGER || fm.type == FieldType.ID_STRING) {
                this.idProperties.add(fld);
            }
            if (fm.attributes.asNameIndex == null) continue;
            nameProperties.put(fld.getName(), fld);
        }
        if (this.getParentModel() != null && this.getParentModel().getNameProperties() != null) {
            List<IPropertyDesc<?>> parentNameProps = this.getParentModel().getNameProperties();
            for (IPropertyDesc<?> pd : parentNameProps) {
                if (nameProperties.containsKey(pd.getName())) continue;
                nameProperties.put(pd.getName(), pd);
            }
        }
        this.nameProperties = new ArrayList(nameProperties.values());
        this.nameProperties.sort(new Comparator<IPropertyDesc<?>>(){

            @Override
            public int compare(IPropertyDesc<?> o1, IPropertyDesc<?> o2) {
                int ret = o1.getAsNameIndex().compareTo(o2.getAsNameIndex());
                if (ret == 0) {
                    return o1.getName().compareTo(o2.getName());
                }
                return ret;
            }
        });
        ArrayList allFields = new ArrayList(declaredProperties);
        if (this.getParentModel() != null) {
            allFields.addAll(this.getParentModel().getFields());
        }
        this.declaredProperties = declaredProperties;
        this.allProperties = allFields;
        if (this.getParentModel() != null) {
            this.getParentModel().registerChild(this);
        } else {
            if (this.nativeModel.typeDescriminatorField != null) {
                this.discriminatorField = this.nativeModel.typeDescriminatorField.trim();
                if (this.discriminatorField.length() == 0) {
                    this.discriminatorField = null;
                }
            }
            if (this.discriminatorField == null) {
                this.discriminatorField = "#type";
            }
        }
    }

    private void registerChild(EntityModel child) {
        if (this.getParentModel() != null) {
            this.getParentModel().registerChild(child);
        }
        this.childModels.put(child.getEntityName(), child);
        String desc = child.nativeModel.typeDescriminator;
        if (desc == null) {
            desc = child.getEntityName();
        }
        this.childModelsByDescriminator.put(desc, child);
    }

    public String getTypeDescriminator() {
        return this.nativeModel.typeDescriminator;
    }

    public EntityListView getListView(String name) {
        EntityListView ret = this.listViews.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new EntityListView(this, name);
        this.listViews.put(name, ret);
        return ret;
    }

    public EntityFormView getFormView(String name) {
        EntityFormView ret = this.formViews.get(name);
        if (ret != null) {
            return ret;
        }
        ret = new EntityFormView(this, name);
        this.formViews.put(name, ret);
        return ret;
    }

    private IPropertyDesc<?> createPropertyDescriptor(String name, PropertyModelDTO field) {
        switch (field.type) {
            case ID_INTEGER: {
                return new IntegerIDPropertyModel(field, name, this);
            }
            case ID_STRING: {
                return new StringIDPropertyModel(field, name, this);
            }
            case ADDR_HOST: 
            case ADDR_IP: {
                return new NetworkAddressPropertyModel(field, name, this);
            }
            case BOOLEAN: {
                return new BooleanPropertyModel(field, name, this);
            }
            case DATE: {
                return new DatePropertyModel(field, name, this);
            }
            case DURATION_ISO: 
            case DURATION_MIN: 
            case DURATION_SECONDS: 
            case DURATION_MS: {
                return new DurationPropertyModel(field, name, this);
            }
            case ENUM: {
                return new EnumPropertyModel(field, name, this);
            }
            case FLOAT: {
                return new FloatPropertyModel(field, name, this);
            }
            case INTEGER: {
                return new IntegerFieldModel(field, name, this);
            }
            case OBJECT_REF: {
                return new EntityReferencePropertyModel(field, name, this);
            }
            case PASSWORD: 
            case TEXT: 
            case TEXT_LONG: 
            case URL: {
                return new TextPropertyModel(field, name, this);
            }
            case TIMESTAMP: 
            case TIMESTAMP_MS: {
                return new TimestampPropertyModel(field, name, this);
            }
            case LINKED_ENTITIES_LIST: {
                return new LinkedEntitiesListPropertyModel(field, name, this);
            }
            case SECRET_KEY: 
            case BINARY_KEY: {
                return new SecretFieldPropertyModel(field, name, this);
            }
        }
        return null;
    }

    public EntityModel getSubtype(String name) {
        EntityModel root = this.getRootModel();
        EntityModel ret = root.childModelsByDescriminator.get(name);
        if (ret == null) {
            ret = root.childModels.get(name);
        }
        return ret;
    }

    public List<EntityModel> getInstantiableTypes() {
        ArrayList<EntityModel> ret = new ArrayList<EntityModel>();
        if (!this.nativeModel.isAbstract) {
            ret.add(this);
        }
        for (EntityModel c : this.childModelsByDescriminator.values()) {
            if (c.nativeModel.isAbstract) continue;
            ret.add(c);
        }
        return ret;
    }

    public String getTypeDiscriminatorField() {
        EntityModel root = this.getRootModel();
        if (root != null) {
            return root.discriminatorField;
        }
        return this.discriminatorField;
    }

    public boolean isRequiredTypeOnUpdate() {
        EntityModel root = this.getRootModel();
        if (root != null) {
            return root.nativeModel.typeOnUpdate;
        }
        return this.nativeModel.typeOnUpdate;
    }

    public EntityModel getEntityType(JSONObject json) {
        EntityModel root = this.getRootModel();
        if (root.childModels.size() == 0) {
            return null;
        }
        if (!json.containsKey(root.discriminatorField)) {
            return null;
        }
        JSONValue jType = json.get(root.discriminatorField);
        if (jType.isString() == null) {
            return null;
        }
        String type = jType.isString().stringValue().trim();
        if (type.length() == 0) {
            return null;
        }
        return root.getSubtype(jType.isString().stringValue().trim());
    }

    public IJSObject getEntityID(JSONObject json, EntityManager em) {
        List<IPropertyDesc<?>> idFields = this.getIdFields();
        if (idFields == null) {
            return null;
        }
        if (idFields.size() == 0) {
            return null;
        }
        if (idFields.size() == 1) {
            IPropertyDesc<?> idFld = idFields.get(0);
            if (!json.containsKey(idFld.getName())) {
                return null;
            }
            return idFld.convertToJSObject(json.get(idFld.getName()), em);
        }
        JSMap ret = new JSMap();
        for (int i = 0; i < idFields.size(); ++i) {
            IPropertyDesc<?> idFld = idFields.get(0);
            if (!json.containsKey(idFld.getName())) {
                return null;
            }
            ret.put(idFld.getName(), idFld.convertToJSObject(json.get(idFld.getName()), em));
        }
        return ret;
    }

    public IJSObject getEntityIDFromValue(JSONValue json, EntityManager em) {
        List<IPropertyDesc<?>> idFields = this.getIdFields();
        if (idFields == null) {
            return null;
        }
        if (idFields.size() == 0) {
            return null;
        }
        if (idFields.size() == 1) {
            IPropertyDesc<?> idFld = idFields.get(0);
            return idFld.convertToJSObject(json, em);
        }
        if (json.isObject() != null) {
            return this.getEntityID(json.isObject(), em);
        }
        return null;
    }

    public List<IPropertyDesc<?>> getDeclaredFields() {
        this.initialize();
        return this.declaredProperties;
    }

    public List<IPropertyDesc<?>> getFields() {
        this.initialize();
        return this.allProperties;
    }

    public Map<String, IPropertyDesc<?>> getFieldsMap() {
        if (this.allPropertiesByName == null) {
            this.allPropertiesByName = new HashMap();
            for (IPropertyDesc<?> d : this.getFields()) {
                this.allPropertiesByName.put(d.getName(), d);
            }
        }
        return this.allPropertiesByName;
    }

    public IPropertyDesc<?> getField(String name) {
        return this.getFieldsMap().get(name);
    }

    public IPropertyDesc<?> findProperty(String name) {
        for (IPropertyDesc<?> p : this.getFields()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public List<IPropertyDesc<?>> getIdFields() {
        this.initialize();
        if (this.idProperties != null && this.idProperties.size() > 0) {
            return this.idProperties;
        }
        EntityModel parent = this.getParentModel();
        if (parent != null) {
            return parent.getIdFields();
        }
        return null;
    }

    public List<IPropertyDesc<?>> getNameProperties() {
        this.initialize();
        if (this.nameProperties != null && this.nameProperties.size() > 0) {
            return this.nameProperties;
        }
        EntityModel parent = this.getParentModel();
        if (parent != null) {
            return parent.getNameProperties();
        }
        return null;
    }

    public EntityModel getParentModel() {
        if (this.nativeModel.superType != null) {
            return ConfigurationRegistry.INSTANCE.getModel(this.nativeModel.superType);
        }
        return null;
    }

    public EntityModel getRootModel() {
        EntityModel parent = this.getParentModel();
        if (parent == null) {
            return this;
        }
        return parent.getRootModel();
    }

    public boolean isParentType(EntityModel m) {
        EntityModel p = this.getParentModel();
        if (p == null) {
            return false;
        }
        if (p == m) {
            return true;
        }
        return p.isParentType(m);
    }

    public static EntityModel parseModel(String json, ConfigurationRegistry registry) {
        GWT.log((String)("Parsing model for json: " + json));
        EntityModelMapper mapper = (EntityModelMapper)GWT.create(EntityModelMapper.class);
        EntityModelDTO model = (EntityModelDTO)mapper.read(json);
        GWT.log((String)("Model parsed for entity type " + model.name));
        return new EntityModel(model, registry);
    }

    public String getDisplayName(String view) {
        String ret = null;
        if (view != null && (view = view.trim()).length() > 0 && (ret = JsonHelper.safeGetString(Localizer.INSTANCE.getMessage(this.getKey() + "." + "views" + "." + view + "." + "name"))) != null) {
            return ret;
        }
        ret = JsonHelper.safeGetString(Localizer.INSTANCE.getMessage(this.getKey() + "." + "name"));
        if (ret != null) {
            return ret;
        }
        return this.getEntityName();
    }

    public String getPluralDisplayName(String view) {
        String ret = null;
        if (view != null && (view = view.trim()).length() > 0) {
            ret = JsonHelper.safeGetString(Localizer.INSTANCE.getMessage(this.getKey() + "." + "views" + "." + view + "." + "pname"));
        }
        if ((ret = JsonHelper.safeGetString(Localizer.INSTANCE.getMessage(this.getKey() + "." + "pname"))) != null) {
            return ret;
        }
        return this.getEntityName() + "(s)";
    }

    public String getKey() {
        return "entities." + this.getEntityName();
    }

    public String getEntityName() {
        return this.nativeModel.name;
    }

    public EntityEditorsDTO getEditorsDTO() {
        if (this.nativeModel.editors != null) {
            return this.nativeModel.editors;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getEditorsDTO();
        }
        return null;
    }

    public String getServiceArgId() {
        if (this.nativeModel.service != null && this.nativeModel.service.argID != null) {
            return this.nativeModel.service.argID;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceArgId();
        }
        return null;
    }

    public String getServiceArgData() {
        if (this.nativeModel.service != null && this.nativeModel.service.argData != null) {
            return this.nativeModel.service.argData;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceArgData();
        }
        return null;
    }

    public String getServiceArgPage() {
        if (this.nativeModel.service != null && this.nativeModel.service.argPage != null) {
            return this.nativeModel.service.argPage;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceArgPage();
        }
        return null;
    }

    public String getServiceName() {
        if (this.nativeModel.service != null && this.nativeModel.service.service != null) {
            return this.nativeModel.service.service;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceName();
        }
        return null;
    }

    public String getServiceMethodList() {
        if (this.nativeModel.service != null && this.nativeModel.service.methodList != null) {
            return this.nativeModel.service.methodList;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceMethodList();
        }
        return null;
    }

    public String getServiceMethodUpdate() {
        if (this.nativeModel.service != null && this.nativeModel.service.methodUpdate != null) {
            return this.nativeModel.service.methodUpdate;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceMethodUpdate();
        }
        return null;
    }

    public String getServiceMethodCreate() {
        if (this.nativeModel.service != null && this.nativeModel.service.methodCreate != null) {
            return this.nativeModel.service.methodCreate;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceMethodCreate();
        }
        return null;
    }

    public String getServiceMethodDelete() {
        if (this.nativeModel.service != null && this.nativeModel.service.methodDelete != null) {
            return this.nativeModel.service.methodDelete;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceMethodDelete();
        }
        return null;
    }

    public String getServiceMethodGet() {
        if (this.nativeModel.service != null && this.nativeModel.service.methodGet != null) {
            return this.nativeModel.service.methodGet;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceMethodGet();
        }
        return null;
    }

    public String getServiceArgPageSize() {
        if (this.nativeModel.service != null && this.nativeModel.service.argPageSize != null) {
            return this.nativeModel.service.argPageSize;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceArgPageSize();
        }
        return null;
    }

    public Map<String, String> getServiceCreateArgs() {
        if (this.nativeModel.service != null && this.nativeModel.service.createArgs != null) {
            return this.nativeModel.service.createArgs;
        }
        if (this.getParentModel() != null) {
            return this.getParentModel().getServiceCreateArgs();
        }
        return null;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canCreate() {
        return true;
    }

    public static interface EntityModelMapper
    extends ObjectMapper<EntityModelDTO> {
    }
}

