/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.lists;

import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.inveed.gwt.editor.client.editor.EntityEditorDialog;
import net.inveed.gwt.editor.client.lists.EntityList;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.LinkedEntitiesListPropertyModel;
import net.inveed.gwt.editor.client.types.JSEntityList;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.Promise;

public class LinkedEntitiesList
extends EntityList {
    private static final Logger LOG = Logger.getLogger(LinkedEntitiesList.class.getName());
    private JSEntityList value;
    private JSEntity entity;
    private LinkedEntitiesListPropertyModel property;

    public void bind(JSEntity entity, LinkedEntitiesListPropertyModel property, String viewName) {
        super.bind(property.getTargetEntityType(), entity.getEntityManager(), viewName);
        this.entity = entity;
        this.property = property;
        this.excludeProperty(property.getMappedByProperty());
    }

    @Override
    protected void refresh() {
        this.fill((List<JSEntity>)this.getValue().getValue());
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    public void setValue(JSEntityList v) {
        this.value = v;
        if (v == null) {
            ListDataProvider data = new ListDataProvider();
            data.addDataDisplay((HasData)this.grid);
            return;
        }
        LOG.fine("Setting non-null list");
        Object list = v.getValue();
        this.fill((List<JSEntity>)list);
        LOG.fine("Fill finished");
    }

    public JSEntityList getValue() {
        return this.value;
    }

    @Override
    protected void onDeleteComplete() {
        ArrayList l = new ArrayList(this.getValue().getValue());
        for (JSEntity e : l) {
            if (!e.isDeleted()) continue;
            this.getValue().remove(e);
        }
        super.onDeleteComplete();
    }

    @Override
    protected void openNewItemEditor(EntityModel model) {
        JSEntity entity = new JSEntity(model, this.entity.getEntityManager());
        entity.setProperty(this.property.getMappedByProperty(), this.entity);
        EntityEditorDialog dialog = new EntityEditorDialog(entity);
        Promise<Boolean, IError> p = dialog.show("formEmbeddedCreate");
        p.thenApply(v -> {
            if (v != null && v.booleanValue()) {
                this.getValue().add(entity);
                this.fill((List<JSEntity>)this.getValue().getValue());
                this.refresh();
            }
            return null;
        });
    }
}

