/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.lists;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.UUID;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.Promise;

public class EntityReferenceCell
extends AbstractCell<JSEntity> {
    private static Template template;
    private final String idPrefix;
    private int order = 0;

    public EntityReferenceCell() {
        super(new String[0]);
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        this.idPrefix = "c_" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public void render(Cell.Context context, JSEntity value, SafeHtmlBuilder sb) {
        if (value == null) {
            sb.append(template.undef());
        } else if (value.isInitialized()) {
            sb.append(template.initialized(value.getDisplayValue()));
        } else {
            String id = this.idPrefix + "_" + this.order;
            ++this.order;
            sb.append(template.uninitialized(id));
            Promise<Void, IError> p = value.load();
            p.thenApply(v -> {
                Element divElement = DOM.getElementById((String)id);
                if (divElement == null) {
                    return null;
                }
                divElement.setInnerText(value.getDisplayValue());
                return null;
            });
            p.onError((v, e) -> null);
        }
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<div id=\"{0}\">...Loading...</div>")
        public SafeHtml uninitialized(String var1);

        @SafeHtmlTemplates.Template(value="<div>-- NOT SET --</div>")
        public SafeHtml undef();

        @SafeHtmlTemplates.Template(value="<div>{0}</div>")
        public SafeHtml initialized(String var1);
    }
}

