/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.lists;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.RangeChangeEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.inveed.gwt.editor.client.editor.EntityEditorDialog;
import net.inveed.gwt.editor.client.i18n.Localizer;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCRequest;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCTransaction;
import net.inveed.gwt.editor.client.model.EntityListView;
import net.inveed.gwt.editor.client.model.EntityManager;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.utils.ErrorWindow;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.JsonHelper;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.QuestionWindow;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.extras.notify.client.constants.NotifyType;
import org.gwtbootstrap3.extras.notify.client.ui.Notify;

public abstract class EntityList
extends Composite {
    private static final EntityListBinder uiBinder = (EntityListBinder)GWT.create(EntityListBinder.class);
    private static final Logger LOG = Logger.getLogger(EntityList.class.getName());
    private final HashMap<String, String> excludedProperties = new HashMap();
    private EntityModel model;
    private EntityListView view;
    private EntityManager entityManager;
    ListDataProvider<JSEntity> dataProvider;
    @UiField
    Heading title;
    @UiField
    Button btnAdd;
    @UiField
    Button btnReload;
    @UiField
    Pagination pagination;
    @UiField
    ButtonGroup bgRight;
    @UiField
    protected CellTable<JSEntity> grid;
    private SimplePager pager = new SimplePager();

    public EntityListView getView() {
        return this.view;
    }

    public EntityModel getEntityModel() {
        return this.model;
    }

    public EntityList() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.dataProvider = new ListDataProvider();
        this.grid.addRangeChangeHandler(new RangeChangeEvent.Handler(){

            public void onRangeChange(RangeChangeEvent event) {
                EntityList.this.pagination.rebuild(EntityList.this.pager);
            }
        });
        this.pager.setDisplay(this.grid);
        this.pagination.clear();
        this.grid.setPageSize(20);
    }

    public void setPageSize(int size) {
        this.grid.setPageSize(size);
    }

    public int getPageSize() {
        return this.grid.getPageSize();
    }

    public void bind(EntityModel model, EntityManager em, String viewName) {
        this.model = model;
        this.entityManager = em;
        this.view = model.getListView(viewName);
        this.addCreateIcon();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void excludeProperty(String pname) {
        this.excludedProperties.put(pname, pname);
    }

    public void includeProperty(String pname) {
        this.excludedProperties.remove(pname, pname);
    }

    public void initialize() {
        LOG.fine("Initializing entity list");
        ArrayList<EntityListView.PropertyInView> displayFields = new ArrayList<EntityListView.PropertyInView>();
        for (EntityListView.PropertyInView f : this.view.getProperties()) {
            if (this.excludedProperties.containsKey(f.property.getName())) continue;
            displayFields.add(f);
        }
        displayFields.sort(new Comparator<EntityListView.PropertyInView>(){

            @Override
            public int compare(EntityListView.PropertyInView o1, EntityListView.PropertyInView o2) {
                int o1Order = o1.order;
                int o2Order = o2.order;
                if (o1Order < o2Order) {
                    return -1;
                }
                if (o1Order > o2Order) {
                    return 1;
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.addLeftSideColumns();
        for (EntityListView.PropertyInView f : displayFields) {
            LOG.fine("Adding column for field " + f.property.getName());
            Column<JSEntity, ?> col = f.property.createTableColumn();
            if (f.width > 0) {
                // empty if block
            }
            String colName = f.getDisplayName();
            LOG.fine("Adding column with name " + colName);
            this.grid.addColumn(col, colName);
        }
        this.addRightSideColumns();
        this.dataProvider.addDataDisplay(this.grid);
    }

    protected void addRightSideColumns() {
        Column<JSEntity, String> colEdit = new Column<JSEntity, String>((Cell)new ButtonCell(ButtonType.DEFAULT, IconType.EDIT)){

            public String getValue(JSEntity object) {
                return null;
            }

            public void render(Cell.Context context, JSEntity entity, SafeHtmlBuilder sb) {
                if (!entity.canEdit()) {
                    sb.appendHtmlConstant("<div/>");
                }
                super.render(context, (Object)entity, sb);
            }
        };
        colEdit.setCellStyleNames("grid-cell-btn");
        colEdit.setFieldUpdater((FieldUpdater)new FieldUpdater<JSEntity, String>(){

            public void update(int index, JSEntity object, String value) {
                EntityList.this.openExistingItemEditor(object);
            }
        });
        Column<JSEntity, String> colDelete = new Column<JSEntity, String>((Cell)new ButtonCell(ButtonType.DEFAULT, IconType.RECYCLE)){

            public String getValue(JSEntity object) {
                return null;
            }

            public void render(Cell.Context context, JSEntity entity, SafeHtmlBuilder sb) {
                if (!entity.canDelete()) {
                    sb.appendHtmlConstant("<div/>");
                }
                super.render(context, (Object)entity, sb);
            }
        };
        colDelete.setFieldUpdater((FieldUpdater)new FieldUpdater<JSEntity, String>(){

            public void update(int index, JSEntity object, String value) {
                EntityList.this.deleteSelectedItem(object);
            }
        });
        colDelete.setCellStyleNames("grid-cell-btn");
        this.grid.addColumn((Column)colEdit);
        this.grid.addColumn((Column)colDelete);
    }

    protected void addLeftSideColumns() {
    }

    private void deleteSelectedItem(JSEntity item) {
        if (item == null) {
            return;
        }
        if (!item.canDelete()) {
            String msg = JsonHelper.safeGetString(Localizer.INSTANCE.getMessage("errors.cannotDelete"));
            Notify.notify((String)msg, (NotifyType)NotifyType.DANGER);
            return;
        }
        Promise<Boolean, IError> p = QuestionWindow.open("You're going to delete '" + item.getDisplayValue() + "'. \r\nContinue?");
        p.thenApply(response -> {
            if (response.booleanValue()) {
                this.deleteSelectedItemsConfirmed(item);
            }
            return null;
        });
    }

    private void addCreateIcon() {
        final List<EntityModel> validTypes = this.model.getInstantiableTypes();
        if (validTypes.size() == 0) {
            return;
        }
        if (validTypes.size() == 1) {
            this.btnAdd.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    EntityList.this.openNewItemEditor((EntityModel)validTypes.get(0));
                }
            });
        } else {
            this.btnAdd.removeFromParent();
            ButtonGroup ddg = new ButtonGroup();
            this.bgRight.insert((Widget)ddg, 0);
            ddg.add((Widget)this.btnAdd);
            this.btnAdd.setDataToggle(Toggle.DROPDOWN);
            DropDownMenu ddm = new DropDownMenu();
            ddg.add((Widget)ddm);
            for (final EntityModel vm : validTypes) {
                AnchorListItem i = new AnchorListItem(vm.getDisplayName(null));
                i.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        EntityList.this.openNewItemEditor(vm);
                    }
                });
                ddm.add((Widget)i);
            }
        }
    }

    private void deleteSelectedItemsConfirmed(JSEntity item) {
        JsonRPCTransaction tran = new JsonRPCTransaction();
        item.delete(tran);
        Promise<JsonRPCTransaction.TransactionResult, IError> p = tran.commit();
        p.thenApply(r -> {
            this.onDeleteComplete();
            return null;
        });
        p.onError((err, t) -> {
            this.onDeleteError((IError)err, item);
            return null;
        });
    }

    private void onDeleteError(IError err, JSEntity item) {
        if (err.getType() == "JsonRPCTransactionError") {
            JsonRPCTransaction.TransactionError e = (JsonRPCTransaction.TransactionError)err;
            ArrayList<JSEntity> problemEntities = new ArrayList<JSEntity>();
            for (JsonRPCRequest.RequestResult ri : e.getResponses()) {
                if (ri.error == null || ri.request.getContext() == null) continue;
                problemEntities.add((JSEntity)ri.request.getContext());
            }
        }
        ErrorWindow.open("Cannot delete items");
    }

    protected void onDeleteComplete() {
        Notify.notify((String)"Item deleted");
        this.refresh();
    }

    protected void openExistingItemEditor(JSEntity entity) {
        EntityEditorDialog dialog = new EntityEditorDialog(entity);
        Promise<Boolean, IError> p = dialog.show("formEdit");
        p.thenApply(v -> {
            if (v != null && v.booleanValue()) {
                this.refresh();
            }
            return null;
        });
    }

    protected abstract void refresh();

    protected abstract void openNewItemEditor(EntityModel var1);

    protected Void fill(List<JSEntity> list) {
        LOG.fine("Array found, size = " + list.size());
        this.dataProvider.getList().clear();
        this.dataProvider.getList().addAll(list);
        this.dataProvider.flush();
        this.pagination.rebuild(this.pager);
        LOG.fine("Fill finished");
        return null;
    }

    static interface EntityListBinder
    extends UiBinder<Widget, EntityList> {
    }
}

