/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.jsonrpc;

import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCClientError;
import net.inveed.gwt.editor.client.utils.HttpClientError;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.JsHttpClient;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.PromiseImpl;

public class JsonRPCClient {
    private static final Logger LOG = Logger.getLogger(JsonRPCClient.class.getName());
    private PromiseImpl<JSONValue, IError> promise;
    private final String json;

    public JsonRPCClient(String json) {
        this.json = json;
    }

    Promise<JSONValue, IError> call(String url) {
        this.promise = new PromiseImpl();
        Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> promise = JsHttpClient.doPost(url, this.json, true);
        promise.onError(this::onError);
        promise.thenApply(this::onComplete);
        return this.promise;
    }

    private Void onError(IError err, Throwable e) {
        LOG.log(Level.WARNING, "Got error while making a JSON-RPC call: " + err.getMessage(), e);
        this.promise.error(err, e);
        return null;
    }

    private Void onComplete(JsHttpClient.RequestResult result) {
        if (result.response == null) {
            LOG.warning("Response is absent");
            this.onError(new HttpClientError(-1), null);
            return null;
        }
        if (result.response.getStatusCode() != 200) {
            LOG.warning("Response has invalid code (non-200)");
            this.onError(new HttpClientError(200), null);
            return null;
        }
        try {
            JSONValue resp = JSONParser.parseStrict((String)result.response.getText());
            if (resp == null) {
                LOG.warning("Cannot parse response");
                this.onError(new JsonRPCClientError(300), null);
                return null;
            }
            this.promise.complete(resp);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Cannot parse response", e);
            this.promise.error(new JsonRPCClientError(999), e);
            return null;
        }
        return null;
    }
}

