/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.i18n;

import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import java.util.logging.Logger;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.JsHttpClient;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.PromiseImpl;

public class Localizer {
    private static final Logger LOG = Logger.getLogger(Localizer.class.getName());
    public static final Localizer INSTANCE = new Localizer();
    private static final String prefix = "/i18n/messages";
    private LocaleInfo currentLocale;
    private JSONObject defaultRoot;
    private JSONObject shortRoot;
    private JSONObject longRoot;

    private Localizer() {
    }

    public Promise<Void, IError> init() {
        LOG.info("Initializing Localizer");
        Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> promise = this.loadLocaleFile("/i18n/messages.json");
        PromiseImpl<Void, IError> ret = new PromiseImpl<Void, IError>();
        promise.thenApply(v -> {
            LOG.fine("Default Localization data loaded. Trying to parse");
            this.defaultRoot = JSONParser.parseStrict((String)v.response.getText()).isObject();
            LOG.info("Default localization data parsed");
            ret.complete(null);
            return null;
        });
        promise.onError((err, t) -> {
            LOG.warning("Cannot load default localization data");
            ret.error((IError)err, (Throwable)t);
            return null;
        });
        return ret;
    }

    public void setLocale(LocaleInfo loc) {
        LOG.info("Setting locale: " + loc.getLocaleName());
        if (this.currentLocale != null && loc.getLocaleName().equals(this.currentLocale.getLocaleName())) {
            LOG.info("Already installed. Nothing to change.");
            return;
        }
        String[] lparts = loc.getLocaleName().split("_");
        if (this.defaultRoot == null) {
            Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> promise = this.loadLocaleFile("/i18n/messages.json");
            promise.thenApply(v -> {
                this.defaultRoot = JSONParser.parseStrict((String)v.response.getText()).isObject();
                return null;
            });
            promise.onError((err, t) -> {
                LOG.warning("Cannot load locale file '/i18n/messages.json'");
                return null;
            });
        }
        if (lparts.length == 2) {
            Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> lPromise = this.loadLocaleFile("/i18n/messages_" + loc + ".json");
            lPromise.thenApply(v -> {
                this.longRoot = JSONParser.parseStrict((String)v.response.getText()).isObject();
                return null;
            });
            lPromise.onError((err, t) -> {
                LOG.warning("Cannot load locale file '/i18n/messages_" + loc + ".json'");
                return null;
            });
            Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> sPromise = this.loadLocaleFile("/i18n/messages_" + lparts[0] + ".json");
            sPromise.thenApply(v -> {
                this.shortRoot = JSONParser.parseStrict((String)v.response.getText()).isObject();
                return null;
            });
            sPromise.onError((err, t) -> {
                LOG.warning("Cannot load locale file '/i18n/messages_" + lparts[0] + ".json'");
                return null;
            });
        } else {
            Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> sPromise = this.loadLocaleFile("/i18n/messages_" + lparts[0] + ".json");
            sPromise.thenApply(v -> {
                this.longRoot = JSONParser.parseStrict((String)v.response.getText()).isObject();
                return null;
            });
            sPromise.onError((err, t) -> {
                LOG.warning("Cannot load locale file '/i18n/messages_" + lparts[0] + ".json'");
                return null;
            });
            this.longRoot = null;
        }
    }

    private Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> loadLocaleFile(String url) {
        Promise<JsHttpClient.RequestResult, JsHttpClient.HTTPError> p = JsHttpClient.doGet(url, false);
        return p;
    }

    public JSONValue getMessage(String code) {
        JSONValue ret;
        LOG.fine("Requested localized message for code '" + code + "'");
        String[] codeParts = code.split("\\.");
        if (this.longRoot != null && (ret = Localizer.getFromRoot(this.longRoot, codeParts)) != null && ret.isNull() == null) {
            LOG.fine("Localized message for code '" + code + "' found with long locale");
            return ret;
        }
        if (this.shortRoot != null && (ret = Localizer.getFromRoot(this.shortRoot, codeParts)) != null && ret.isNull() == null) {
            LOG.fine("Localized message for code '" + code + "' found with short locale");
            return ret;
        }
        if (this.defaultRoot != null && (ret = Localizer.getFromRoot(this.defaultRoot, codeParts)) != null && ret.isNull() == null) {
            LOG.fine("Localized message for code '" + code + "' found with default locale");
            return ret;
        }
        LOG.warning("Localized message for code '" + code + "' not found");
        return JSONNull.getInstance();
    }

    private static final JSONValue getFromRoot(JSONObject root, String[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            String code = parts[i];
            if (!root.containsKey(code)) {
                return null;
            }
            JSONValue v = root.get(code);
            if (i == parts.length - 1) {
                return v;
            }
            if (v.isObject() == null) {
                LOG.warning("Unknown error");
                return null;
            }
            root = v.isObject();
        }
        return null;
    }

    public boolean isInitialized() {
        return this.defaultRoot != null;
    }
}

