/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.TextPropertyModel;
import net.inveed.gwt.editor.client.types.JSString;
import net.inveed.gwt.editor.client.utils.StringFormatter;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.TextArea;
import org.gwtbootstrap3.client.ui.base.ValueBoxBase;
import org.gwtbootstrap3.client.ui.form.validator.RegExValidator;
import org.gwtbootstrap3.client.ui.form.validator.SizeValidator;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

public class SingleRowTextPropertyEditor
extends AbstractFormPropertyEditor<TextPropertyModel, JSString> {
    private static final String ERR_LENGTH_BETWEEN = "txtLengthBetween";
    private static final String ERR_LENGTH_MORETHAN = "txtLengthMore";
    private static final String ERR_LENGTH_LESSTHAN = "txtLengthLess";
    private static final String ERR_LENGTH_LESSTHAN_NOEMPTY = "txtLengthLessNoEmpty";
    private ValueBoxBase<String> textBox;

    public SingleRowTextPropertyEditor(boolean multiline) {
        this.textBox = !multiline ? new Input() : new TextArea();
        this.textBox.setValidateOnBlur(true);
        this.textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SingleRowTextPropertyEditor.this.onValueChanged();
            }
        });
        this.textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                SingleRowTextPropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.textBox);
    }

    @Override
    public void setId(String uid) {
        this.textBox.setId(uid);
    }

    @Override
    public void bind(JSEntity entity, TextPropertyModel field, String viewName) {
        SizeValidator sv;
        String regex;
        super.bind(entity, field, viewName);
        this.textBox.setReadOnly(this.isReadonly());
        String nregex = ((TextPropertyModel)this.getProperty()).getNativeRegex();
        if (nregex != null) {
            RegExValidator rv = new RegExValidator(nregex, ((TextPropertyModel)this.getProperty()).getNativeRegexError(this.getViewName()));
            this.textBox.addValidator((Validator)rv);
        }
        if ((regex = ((TextPropertyModel)this.getProperty()).getRegEx()) != null) {
            RegExValidator rv = new RegExValidator(regex, ((TextPropertyModel)this.getProperty()).getRegexError(this.getViewName()));
            this.textBox.addValidator((Validator)rv);
        }
        if (((TextPropertyModel)this.getProperty()).getMaxLength() != null && ((TextPropertyModel)this.getProperty()).getMinLength() != null) {
            sv = new SizeValidator(((TextPropertyModel)this.getProperty()).getMinLength(), ((TextPropertyModel)this.getProperty()).getMaxLength(), StringFormatter.format(((TextPropertyModel)this.getProperty()).getError(ERR_LENGTH_BETWEEN, this.getViewName()), ((TextPropertyModel)this.getProperty()).getMinLength(), ((TextPropertyModel)this.getProperty()).getMaxLength()));
            this.textBox.addValidator((Validator)sv);
        } else if (((TextPropertyModel)this.getProperty()).getMaxLength() != null) {
            sv = new SizeValidator(Integer.valueOf(((TextPropertyModel)this.getProperty()).isRequired() ? 1 : 0), ((TextPropertyModel)this.getProperty()).getMaxLength(), StringFormatter.format(((TextPropertyModel)this.getProperty()).getError(((TextPropertyModel)this.getProperty()).isRequired() ? ERR_LENGTH_LESSTHAN_NOEMPTY : ERR_LENGTH_LESSTHAN, this.getViewName()), ((TextPropertyModel)this.getProperty()).getMaxLength()));
            this.textBox.addValidator((Validator)sv);
        } else if (((TextPropertyModel)this.getProperty()).getMinLength() != null) {
            sv = new SizeValidator(((TextPropertyModel)this.getProperty()).getMinLength(), Integer.valueOf(Integer.MAX_VALUE), StringFormatter.format(((TextPropertyModel)this.getProperty()).getError(ERR_LENGTH_MORETHAN, this.getViewName()), ((TextPropertyModel)this.getProperty()).getMinLength()));
            this.textBox.addValidator((Validator)sv);
        }
        if (((TextPropertyModel)this.getProperty()).getMaxLength() != null) {
            this.textBox.setMaxLength(((TextPropertyModel)this.getProperty()).getMaxLength().intValue());
        }
        if (this.getOriginalValue() != null) {
            this.textBox.setValue((Object)((JSString)this.getOriginalValue()).getValue());
        }
    }

    @Override
    protected Widget getChildWidget() {
        return this.textBox;
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        this.textBox.setValue((Object)v);
    }

    @Override
    protected void onValueChanged() {
        super.onValueChanged();
        this.textBox.validate();
    }

    @Override
    public boolean validate() {
        if (((TextPropertyModel)this.getProperty()).isRequired() && this.textBox.getValue() == null) {
            return false;
        }
        if (this.textBox.getValue() == null) {
            return true;
        }
        return this.textBox.validate(false);
    }

    @Override
    public JSString getValue() {
        String v = (String)this.textBox.getValue();
        if (v == null) {
            return null;
        }
        return new JSString(v);
    }

    @Override
    public void setEnabled(boolean value) {
        this.textBox.setEnabled(value);
    }
}

