/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.github.nmorel.gwtjackson.client.utils.Base64Utils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.SecretFieldPropertyModel;
import net.inveed.gwt.editor.client.types.JSString;
import net.inveed.gwt.editor.client.utils.ByteArrayConvertor;
import net.inveed.gwt.editor.client.utils.CryptoHelper;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.InputGroupButton;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;

public class SecretKeyPropertyEditor
extends AbstractFormPropertyEditor<SecretFieldPropertyModel, JSString> {
    private static final String FMT_HEX = "HEX";
    private static final String FMT_BASE64 = "Base64";
    private InputGroup widget;
    private int length = 16;
    private byte[] value;
    private boolean valid;
    private Button btnFormat;
    private TextBox textBox;
    private Button btnGenerate;
    private boolean isHex;

    public SecretKeyPropertyEditor(int length, boolean autoGen) {
        this.length = length;
        this.widget = new InputGroup();
        InputGroupButton igFormat = new InputGroupButton();
        this.btnFormat = new Button();
        this.btnFormat.setDataToggle(Toggle.DROPDOWN);
        this.btnFormat.setWidth("6em");
        DropDownMenu ddmFormat = new DropDownMenu();
        AnchorListItem aliBase64 = new AnchorListItem(FMT_BASE64);
        AnchorListItem aliHex = new AnchorListItem(FMT_HEX);
        ddmFormat.add((Widget)aliBase64);
        ddmFormat.add((Widget)aliHex);
        igFormat.add((Widget)this.btnFormat);
        igFormat.add((Widget)ddmFormat);
        this.btnFormat.setText(FMT_BASE64);
        this.isHex = false;
        this.textBox = new TextBox();
        this.textBox.addStyleName("monospace");
        this.widget.add((Widget)igFormat);
        this.widget.add((Widget)this.textBox);
        if (autoGen) {
            InputGroupButton gbtn = new InputGroupButton();
            this.btnGenerate = new Button();
            this.btnGenerate.setIcon(IconType.REFRESH);
            gbtn.add((Widget)this.btnGenerate);
            this.widget.add((Widget)gbtn);
            this.btnGenerate.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SecretKeyPropertyEditor.this.generate();
                    SecretKeyPropertyEditor.this.onValueChanged();
                }
            });
        }
        aliBase64.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SecretKeyPropertyEditor.this.btnFormat.setText(SecretKeyPropertyEditor.FMT_BASE64);
                SecretKeyPropertyEditor.this.isHex = false;
                SecretKeyPropertyEditor.this.updateView();
            }
        });
        aliHex.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SecretKeyPropertyEditor.this.btnFormat.setText(SecretKeyPropertyEditor.FMT_HEX);
                SecretKeyPropertyEditor.this.isHex = true;
                SecretKeyPropertyEditor.this.updateView();
            }
        });
        this.textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                SecretKeyPropertyEditor.this.validateValue();
                SecretKeyPropertyEditor.this.onValueChanged();
            }
        });
        this.textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SecretKeyPropertyEditor.this.validateValue();
                SecretKeyPropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.widget);
    }

    @Override
    public void setId(String uid) {
        this.widget.setId(uid);
    }

    @Override
    public void bind(JSEntity entity, SecretFieldPropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        if (this.getOriginalValue() != null) {
            this.setValue((JSString)this.getOriginalValue());
        }
    }

    @Override
    protected Widget getChildWidget() {
        return this.widget;
    }

    @Override
    public void setValue(String v) {
        byte[] bv2;
        if (v == null) {
            this.textBox.setValue((Object)"");
            this.setValid(true);
            return;
        }
        if ((v = v.trim()).length() == 0) {
            this.textBox.setValue((Object)"");
            this.setValid(true);
            return;
        }
        try {
            bv2 = Base64Utils.fromBase64((String)v);
            if (bv2 != null) {
                this.value = bv2;
                this.setValid(true);
                return;
            }
        }
        catch (Throwable bv2) {
            // empty catch block
        }
        try {
            bv2 = ByteArrayConvertor.hexStringToByteArray(v);
            if (bv2 != null) {
                this.value = bv2;
                this.setValid(true);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.textBox.setValue((Object)v);
        this.setValid(false);
    }

    public byte[] getByteValue() {
        return this.value;
    }

    public String getBase64Value() {
        if (this.value == null) {
            return null;
        }
        return Base64Utils.toBase64((byte[])this.value);
    }

    public String getHexValue() {
        if (this.value == null) {
            return null;
        }
        return ByteArrayConvertor.toHexString(this.value);
    }

    private void setValid(boolean v) {
        if (!v) {
            this.btnFormat.setEnabled(false);
        } else {
            this.btnFormat.setEnabled(this.textBox.isEnabled());
        }
        this.valid = v;
    }

    private void validateValue() {
        String tv = this.textBox.getValue();
        if (tv == null) {
            this.value = null;
            this.setValid(false);
            return;
        }
        if ((tv = tv.trim()).length() == 0) {
            this.value = null;
            this.setValid(true);
            return;
        }
        if (!this.isHex) {
            try {
                byte[] bv = Base64Utils.fromBase64((String)tv);
                if (bv == null) {
                    this.setValid(false);
                    return;
                }
                if (bv.length != this.length) {
                    this.setValid(false);
                    return;
                }
                this.value = bv;
                this.setValid(true);
                return;
            }
            catch (Throwable e) {
                this.setValid(false);
                return;
            }
        }
        try {
            byte[] bv = ByteArrayConvertor.hexStringToByteArray(tv);
            if (bv == null) {
                this.setValid(false);
                return;
            }
            if (bv.length != this.length) {
                this.setValid(false);
                return;
            }
            this.value = bv;
            this.setValid(true);
            return;
        }
        catch (Throwable e) {
            this.setValid(false);
            return;
        }
    }

    private void setValue(JSString originalValue) {
        if (originalValue != null) {
            this.textBox.setValue((Object)originalValue.getValue());
        } else {
            this.textBox.setValue(null);
        }
    }

    private void updateView() {
        if (this.value == null) {
            this.textBox.setValue((Object)"");
            return;
        }
        if (!this.isHex) {
            this.textBox.setValue((Object)Base64Utils.toBase64((byte[])this.value));
        } else {
            this.textBox.setValue((Object)ByteArrayConvertor.toHexString(this.value));
        }
    }

    private void generate() {
        this.value = CryptoHelper.generateRandomSeed(this.length);
        this.updateView();
    }

    @Override
    public boolean validate() {
        if (((SecretFieldPropertyModel)this.getProperty()).isRequired() && (this.textBox.getValue() == null || this.textBox.getValue().trim().length() == 0)) {
            return false;
        }
        this.validateValue();
        return this.valid;
    }

    @Override
    public JSString getValue() {
        String v = this.getBase64Value();
        if (v == null) {
            return null;
        }
        return new JSString(v);
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.btnGenerate != null) {
            this.btnGenerate.setEnabled(value);
        }
        this.textBox.setEnabled(value);
        this.validateValue();
    }
}

