/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.NetworkAddressPropertyModel;
import net.inveed.gwt.editor.client.types.JSNetworkAddress;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.form.validator.RegExValidator;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

public class NetworkAddressPropertyEditor
extends AbstractFormPropertyEditor<NetworkAddressPropertyModel, JSNetworkAddress> {
    private static final String IPv4Regex = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";
    private Input textBox = new Input();

    public NetworkAddressPropertyEditor() {
        this.textBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                NetworkAddressPropertyEditor.this.onValueChanged();
            }
        });
        this.textBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                NetworkAddressPropertyEditor.this.onValueChanged();
            }
        });
        RegExValidator rv = new RegExValidator(IPv4Regex);
        this.textBox.addValidator((Validator)rv);
        this.add((Widget)this.textBox);
    }

    @Override
    public void bind(JSEntity entity, NetworkAddressPropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        this.textBox.setReadOnly(this.isReadonly());
        if (this.getOriginalValue() != null) {
            this.textBox.setValue((Object)((JSNetworkAddress)this.getOriginalValue()).getValue());
        }
    }

    @Override
    public void setId(String uid) {
        this.textBox.setId(uid);
    }

    @Override
    protected Widget getChildWidget() {
        return this.textBox;
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        this.textBox.setValue((Object)v);
    }

    @Override
    protected void onValueChanged() {
        super.onValueChanged();
        this.textBox.validate();
    }

    @Override
    public JSNetworkAddress getValue() {
        String v = (String)this.textBox.getValue();
        if (v == null) {
            return null;
        }
        return new JSNetworkAddress(v);
    }

    @Override
    public boolean validate() {
        if (((NetworkAddressPropertyModel)this.getProperty()).isRequired() && this.textBox.getValue() == null) {
            return false;
        }
        if (this.textBox.getValue() == null) {
            return true;
        }
        return this.textBox.validate(false);
    }

    @Override
    public void setEnabled(boolean value) {
        this.textBox.setEnabled(value);
    }
}

