/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.IntegerFieldModel;
import net.inveed.gwt.editor.client.types.JSLong;
import org.gwtbootstrap3.client.ui.IntegerBox;
import org.gwtbootstrap3.client.ui.form.validator.DecimalMaxValidator;
import org.gwtbootstrap3.client.ui.form.validator.DecimalMinValidator;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

public class IntegerPropertyEditor
extends AbstractFormPropertyEditor<IntegerFieldModel, JSLong> {
    private IntegerBox tbInteger = new IntegerBox();

    public IntegerPropertyEditor() {
        this.tbInteger.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                IntegerPropertyEditor.this.onValueChanged();
            }
        });
        this.tbInteger.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                IntegerPropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.tbInteger);
    }

    @Override
    public void bind(JSEntity entity, IntegerFieldModel field, String viewName) {
        super.bind(entity, field, viewName);
        this.tbInteger.setReadOnly(this.isReadonly());
        if (((IntegerFieldModel)this.getProperty()).getMaxValue() != null) {
            this.tbInteger.addValidator((Validator)new DecimalMaxValidator((Number)((IntegerFieldModel)this.getProperty()).getMaxValue().intValue()));
        }
        if (((IntegerFieldModel)this.getProperty()).getMinValue() != null) {
            this.tbInteger.addValidator((Validator)new DecimalMinValidator((Number)((IntegerFieldModel)this.getProperty()).getMinValue().intValue()));
        }
        if (this.getOriginalValue() != null) {
            this.tbInteger.setValue((Object)((JSLong)this.getOriginalValue()).getValue().intValue());
        }
    }

    @Override
    public void setId(String uid) {
        this.tbInteger.setId(uid);
    }

    @Override
    protected Widget getChildWidget() {
        return this.tbInteger;
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        this.tbInteger.setValue((Object)Integer.parseInt(v));
    }

    @Override
    protected void onValueChanged() {
        super.onValueChanged();
        this.tbInteger.validate();
    }

    @Override
    public boolean validate() {
        if (((IntegerFieldModel)this.getProperty()).isRequired() && this.tbInteger.getValue() == null) {
            return false;
        }
        if (this.tbInteger.getValue() == null) {
            return true;
        }
        return this.tbInteger.validate(false);
    }

    @Override
    public JSLong getValue() {
        Integer v = (Integer)this.tbInteger.getValue();
        if (v == null) {
            return null;
        }
        return new JSLong(v.intValue());
    }

    @Override
    public boolean isModified() {
        if (this.isReadonly()) {
            return false;
        }
        if (this.getOriginalValue() == null && this.tbInteger.getValue() == null) {
            return false;
        }
        if (this.getOriginalValue() != null && this.tbInteger.getValue() != null) {
            return !((JSLong)this.getOriginalValue()).equals(this.tbInteger.getValue());
        }
        return true;
    }

    @Override
    public void setEnabled(boolean value) {
        this.tbInteger.setEnabled(value);
    }
}

