/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.DurationPropertyModel;
import net.inveed.gwt.editor.client.types.JSTimeInterval;
import org.gwtbootstrap3.client.ui.DoubleBox;
import org.gwtbootstrap3.client.ui.InputGroup;
import org.gwtbootstrap3.client.ui.InputGroupAddon;
import org.gwtbootstrap3.client.ui.IntegerBox;
import org.gwtbootstrap3.client.ui.base.ValueBoxBase;

public class DurationPropertyEditor
extends AbstractFormPropertyEditor<DurationPropertyModel, JSTimeInterval> {
    private InputGroup widget = new InputGroup();
    private IntegerBox yearsTb;
    private IntegerBox monthsTb;
    private IntegerBox daysTb;
    private IntegerBox hoursTb;
    private IntegerBox minutesTb;
    private DoubleBox secondsTb;

    private InputGroupAddon createAddonBox(String text) {
        InputGroupAddon ret = new InputGroupAddon();
        ret.setText(text);
        return ret;
    }

    public DurationPropertyEditor() {
        this.add((Widget)this.widget);
    }

    @Override
    public void bind(JSEntity entity, DurationPropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        boolean ro = this.isReadonly();
        if (((DurationPropertyModel)this.getProperty()).getFormat() == JSTimeInterval.Format.ISO) {
            this.yearsTb = new IntegerBox();
            this.yearsTb.setValue((Object)0);
            this.addListener((ValueBoxBase<?>)this.yearsTb);
            this.monthsTb = new IntegerBox();
            this.monthsTb.setReadOnly(ro);
            this.addListener((ValueBoxBase<?>)this.monthsTb);
            this.widget.add((Widget)this.yearsTb);
            this.widget.add((Widget)this.createAddonBox("Years"));
            this.widget.add((Widget)this.monthsTb);
            this.widget.add((Widget)this.createAddonBox("Months"));
        }
        this.daysTb = new IntegerBox();
        this.addListener((ValueBoxBase<?>)this.daysTb);
        this.hoursTb = new IntegerBox();
        this.addListener((ValueBoxBase<?>)this.hoursTb);
        this.minutesTb = new IntegerBox();
        this.addListener((ValueBoxBase<?>)this.minutesTb);
        this.widget.add((Widget)this.daysTb);
        this.widget.add((Widget)this.createAddonBox("Days"));
        this.widget.add((Widget)this.hoursTb);
        this.widget.add((Widget)this.createAddonBox("Hrs"));
        this.widget.add((Widget)this.minutesTb);
        this.widget.add((Widget)this.createAddonBox("Min"));
        if (((DurationPropertyModel)this.getProperty()).getFormat() != JSTimeInterval.Format.MINUTES) {
            this.secondsTb = new DoubleBox();
            this.addListener((ValueBoxBase<?>)this.secondsTb);
            this.widget.add((Widget)this.secondsTb);
            this.widget.add((Widget)this.createAddonBox("Sec"));
        }
        this.setValue((JSTimeInterval)this.getOriginalValue());
    }

    @Override
    protected Widget getChildWidget() {
        return this.widget;
    }

    private void addListener(ValueBoxBase<?> b) {
        b.addValueChangeHandler(new ValueChangeHandler(){

            public void onValueChange(ValueChangeEvent event) {
                DurationPropertyEditor.this.onValueChanged();
            }
        });
        b.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                DurationPropertyEditor.this.onValueChanged();
            }
        });
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        if ((v = v.trim()).length() == 0) {
            return;
        }
        try {
            Double d = Double.parseDouble(v);
            JSONNumber num = new JSONNumber(d.doubleValue());
            JSTimeInterval ival = JSTimeInterval.parse((JSONValue)num, ((DurationPropertyModel)this.getProperty()).getFormat());
            if (ival != null) {
                this.setValue(ival);
                return;
            }
        }
        catch (Exception d) {
            // empty catch block
        }
        JSONString jstring = new JSONString(v);
        JSTimeInterval ival = JSTimeInterval.parse((JSONValue)jstring, ((DurationPropertyModel)this.getProperty()).getFormat());
        if (ival != null) {
            this.setValue(ival);
        }
    }

    public void setValue(JSTimeInterval interval) {
        if (interval == null) {
            return;
        }
        if (((DurationPropertyModel)this.getProperty()).getFormat() == JSTimeInterval.Format.ISO) {
            this.yearsTb.setValue((Object)interval.getHYears());
            this.monthsTb.setValue((Object)interval.getHMonths());
        }
        this.daysTb.setValue((Object)((int)interval.getHDays()));
        this.hoursTb.setValue((Object)((int)interval.getHHours()));
        this.minutesTb.setValue((Object)((int)interval.getHMinutes()));
        if (((DurationPropertyModel)this.getProperty()).getFormat() != JSTimeInterval.Format.MINUTES) {
            this.secondsTb.setValue((Object)interval.getHSeconds());
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public JSTimeInterval getValue() {
        Double seconds = null;
        if (this.secondsTb != null) {
            seconds = (Double)this.secondsTb.getValue();
        }
        if (((DurationPropertyModel)this.getProperty()).getFormat() == JSTimeInterval.Format.ISO) {
            Integer years = null;
            Integer months = null;
            if (this.yearsTb.getValue() != null) {
                years = (int)((Integer)this.yearsTb.getValue());
            }
            if (this.monthsTb.getValue() != null) {
                months = (int)((Integer)this.monthsTb.getValue());
            }
            return new JSTimeInterval(years, months, (Integer)this.daysTb.getValue(), (Integer)this.hoursTb.getValue(), (Integer)this.minutesTb.getValue(), seconds, ((DurationPropertyModel)this.getProperty()).getFormat());
        }
        return new JSTimeInterval(0, 0, (Integer)this.daysTb.getValue(), (Integer)this.hoursTb.getValue(), (Integer)this.minutesTb.getValue(), seconds, ((DurationPropertyModel)this.getProperty()).getFormat());
    }

    @Override
    public void setId(String uid) {
        this.widget.setId(uid);
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.daysTb != null) {
            this.daysTb.setEnabled(value);
        }
        if (this.hoursTb != null) {
            this.hoursTb.setEnabled(value);
        }
        if (this.minutesTb != null) {
            this.minutesTb.setEnabled(value);
        }
        if (this.monthsTb != null) {
            this.monthsTb.setEnabled(value);
        }
        if (this.secondsTb != null) {
            this.secondsTb.setEnabled(value);
        }
        if (this.yearsTb != null) {
            this.yearsTb.setEnabled(value);
        }
    }
}

