/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.FloatPropertyModel;
import net.inveed.gwt.editor.client.types.JSDouble;
import org.gwtbootstrap3.client.ui.DoubleBox;
import org.gwtbootstrap3.client.ui.form.validator.DecimalMaxValidator;
import org.gwtbootstrap3.client.ui.form.validator.DecimalMinValidator;
import org.gwtbootstrap3.client.ui.form.validator.Validator;

public class DoublePropertyEditor
extends AbstractFormPropertyEditor<FloatPropertyModel, JSDouble> {
    private DoubleBox tbDouble = new DoubleBox();

    public DoublePropertyEditor() {
        this.tbDouble.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Double>(){

            public void onValueChange(ValueChangeEvent<Double> event) {
                DoublePropertyEditor.this.onValueChanged();
            }
        });
        this.tbDouble.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                DoublePropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.tbDouble);
    }

    @Override
    public void bind(JSEntity entity, FloatPropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        this.tbDouble.setReadOnly(this.isReadonly());
        if (((FloatPropertyModel)this.getProperty()).getMaxValue() != null) {
            this.tbDouble.addValidator((Validator)new DecimalMaxValidator((Number)((FloatPropertyModel)this.getProperty()).getMaxValue()));
        }
        if (((FloatPropertyModel)this.getProperty()).getMinValue() != null) {
            this.tbDouble.addValidator((Validator)new DecimalMinValidator((Number)((FloatPropertyModel)this.getProperty()).getMinValue()));
        }
        if (this.getOriginalValue() != null) {
            this.tbDouble.setValue((Object)((JSDouble)this.getOriginalValue()).getValue());
        }
    }

    @Override
    protected Widget getChildWidget() {
        return this.tbDouble;
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        this.tbDouble.setValue((Object)Double.parseDouble(v));
    }

    @Override
    protected void onValueChanged() {
        super.onValueChanged();
        this.tbDouble.validate();
    }

    @Override
    public boolean validate() {
        if (((FloatPropertyModel)this.getProperty()).isRequired() && this.tbDouble.getValue() == null) {
            return false;
        }
        if (this.tbDouble.getValue() == null) {
            return true;
        }
        return this.tbDouble.validate(false);
    }

    @Override
    public JSDouble getValue() {
        Double v = (Double)this.tbDouble.getValue();
        if (v == null) {
            return null;
        }
        return new JSDouble(v);
    }

    @Override
    public boolean isModified() {
        if (this.isReadonly()) {
            return false;
        }
        if (this.getOriginalValue() == null && this.tbDouble.getValue() == null) {
            return false;
        }
        if (this.getOriginalValue() != null && this.tbDouble.getValue() != null) {
            return !((JSDouble)this.getOriginalValue()).equals(this.tbDouble.getValue());
        }
        return true;
    }

    @Override
    public void setId(String uid) {
        this.tbDouble.setId(uid);
    }

    @Override
    public void setEnabled(boolean value) {
        this.tbDouble.setEnabled(value);
    }
}

