/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.DatePropertyModel;
import net.inveed.gwt.editor.client.types.JSDate;
import org.gwtbootstrap3.extras.datepicker.client.ui.DatePicker;

public class DatePropertyEditor
extends AbstractFormPropertyEditor<DatePropertyModel, JSDate> {
    private DatePicker datePicker = new DatePicker();

    public DatePropertyEditor() {
        this.datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                DatePropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.datePicker);
    }

    @Override
    public void bind(JSEntity entity, DatePropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        this.datePicker.setReadOnly(this.isReadonly());
        if (this.getOriginalValue() != null) {
            this.datePicker.setValue(((JSDate)this.getOriginalValue()).getValue());
        }
    }

    @Override
    protected Widget getChildWidget() {
        return this.datePicker;
    }

    @Override
    public void setValue(String v) {
        if (v == null) {
            return;
        }
        if ((v = v.trim().toLowerCase()).equals("now")) {
            this.datePicker.setValue(new Date());
            return;
        }
    }

    @Override
    protected void onValueChanged() {
        super.onValueChanged();
        this.datePicker.validate();
    }

    @Override
    public boolean validate() {
        if (((DatePropertyModel)this.getProperty()).isRequired() && this.datePicker.getValue() == null) {
            return false;
        }
        if (this.datePicker.getValue() == null) {
            return true;
        }
        return this.datePicker.validate(false);
    }

    @Override
    public JSDate getValue() {
        return new JSDate(this.datePicker.getValue(), null);
    }

    @Override
    public void setId(String uid) {
        this.datePicker.setId(uid);
    }

    @Override
    public void setEnabled(boolean value) {
        this.datePicker.setEnabled(value);
    }
}

