/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.fields;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Widget;
import net.inveed.gwt.editor.client.editor.fields.AbstractFormPropertyEditor;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.model.properties.BooleanPropertyModel;
import net.inveed.gwt.editor.client.types.JSBoolean;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.ToggleSwitch;
import org.gwtbootstrap3.extras.toggleswitch.client.ui.base.constants.SizeType;

public class BooleanPropertyEditor
extends AbstractFormPropertyEditor<BooleanPropertyModel, JSBoolean> {
    private ToggleSwitch checkbox = new ToggleSwitch();

    public BooleanPropertyEditor() {
        this.checkbox.setOnIcon(IconType.CHECK);
        this.checkbox.setOffIcon(IconType.TIMES);
        this.checkbox.setSize(SizeType.MINI);
        this.checkbox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                BooleanPropertyEditor.this.onValueChanged();
            }
        });
        this.add((Widget)this.checkbox);
    }

    @Override
    protected Widget getChildWidget() {
        return this.checkbox;
    }

    @Override
    public void bind(JSEntity entity, BooleanPropertyModel field, String viewName) {
        super.bind(entity, field, viewName);
        if (this.isReadonly()) {
            this.checkbox.setEnabled(false);
        }
        if (this.getOriginalValue() != null) {
            this.checkbox.setValue(((JSBoolean)this.getOriginalValue()).getValue());
        }
    }

    @Override
    public void setValue(String v) {
        if (this.checkbox == null) {
            return;
        }
        if (v == null) {
            this.checkbox.setValue(Boolean.valueOf(false));
            return;
        }
        if ((v = v.trim().toLowerCase()).equals("true") || v.equals("yes") || v.equals("1")) {
            this.checkbox.setValue(Boolean.valueOf(true));
        } else {
            this.checkbox.setValue(Boolean.valueOf(false));
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public JSBoolean getValue() {
        if (this.checkbox.getValue() == null) {
            return null;
        }
        if (this.checkbox.getValue().booleanValue()) {
            return JSBoolean.TRUE;
        }
        return JSBoolean.FALSE;
    }

    @Override
    public void setId(String uid) {
        this.checkbox.setId(uid);
    }

    @Override
    public void setEnabled(boolean value) {
        this.checkbox.setEnabled(value);
    }
}

