/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor.auto;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.inveed.gwt.editor.client.editor.auto.AutoFormField;
import net.inveed.gwt.editor.client.editor.auto.AutoFormSection;
import net.inveed.gwt.editor.client.editor.auto.AutoFormSimpleField;
import net.inveed.gwt.editor.shared.FormFieldLocation;
import org.gwtbootstrap3.client.ui.FormGroup;

public class AutoFormSimpleFieldsSection
extends AutoFormSection {
    private final List<AutoFormSimpleField> fields = new ArrayList<AutoFormSimpleField>();
    private int order = 0;

    public AutoFormSimpleFieldsSection(String name) {
        super(name);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void addField(AutoFormSimpleField fld) {
        this.fields.add(fld);
    }

    @Override
    public void build() {
        HashMap fieldsByRow = new HashMap();
        int failedRows = 100000;
        for (AutoFormSimpleField fld : this.fields) {
            int rowNumber = fld.getPropertyInView().attr.order;
            ArrayList<AutoFormSimpleField> l = (ArrayList<AutoFormSimpleField>)fieldsByRow.get(rowNumber);
            if (l == null) {
                l = new ArrayList<AutoFormSimpleField>();
                fieldsByRow.put(rowNumber, l);
            }
            if (l.size() > 1) {
                rowNumber = failedRows++;
                l = new ArrayList();
                fieldsByRow.put(rowNumber, l);
            }
            l.add(fld);
        }
        ArrayList rowNumbers = new ArrayList(fieldsByRow.keySet());
        Collections.sort(rowNumbers);
        this.add((Widget)this.getLegend());
        for (Integer k : rowNumbers) {
            ArrayList r = (ArrayList)fieldsByRow.get(k);
            if (r == null || r.size() > 2) continue;
            FormGroup fg = new FormGroup();
            if (r.size() == 2) {
                Collections.sort(r, new Comparator<AutoFormField>(){

                    @Override
                    public int compare(AutoFormField o1, AutoFormField o2) {
                        int ret = Integer.compare(o1.getPropertyInView().attr.order, o2.getPropertyInView().attr.order);
                        if (ret == 0) {
                            if (o1.getPropertyInView().attr.location == FormFieldLocation.LEFT && o2.getPropertyInView().attr.location == FormFieldLocation.RIGHT) {
                                return -1;
                            }
                            if (o2.getPropertyInView().attr.location == FormFieldLocation.LEFT && o1.getPropertyInView().attr.location == FormFieldLocation.RIGHT) {
                                return 1;
                            }
                        }
                        return o1.getPropertyInView().property.getName().compareTo(o2.getPropertyInView().property.getName());
                    }
                });
                ((AutoFormSimpleField)r.get(0)).setFullWidth(false);
                ((AutoFormSimpleField)r.get(1)).setFullWidth(false);
                fg.add((Widget)((AutoFormSimpleField)r.get(0)).getLabel());
                fg.add((Widget)((AutoFormSimpleField)r.get(0)).getPanel());
                fg.add((Widget)((AutoFormSimpleField)r.get(1)).getLabel());
                fg.add((Widget)((AutoFormSimpleField)r.get(1)).getPanel());
            } else {
                ((AutoFormSimpleField)r.get(0)).setFullWidth(true);
                fg.add((Widget)((AutoFormSimpleField)r.get(0)).getLabel());
                fg.add((Widget)((AutoFormSimpleField)r.get(0)).getPanel());
            }
            this.add((Widget)fg);
        }
    }
}

