/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.editor.client.editor;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.logging.Logger;
import net.inveed.gwt.editor.client.ProgressBarController;
import net.inveed.gwt.editor.client.RootContainer;
import net.inveed.gwt.editor.client.editor.AbstractEntityEditorForm;
import net.inveed.gwt.editor.client.editor.EntityEditorRegistry;
import net.inveed.gwt.editor.client.editor.IEntityEditorFactory;
import net.inveed.gwt.editor.client.editor.auto.AutoEntityEditorForm;
import net.inveed.gwt.editor.client.editor.fields.AbstractPropertyEditor;
import net.inveed.gwt.editor.client.jsonrpc.JsonRPCTransaction;
import net.inveed.gwt.editor.client.model.EntityFormView;
import net.inveed.gwt.editor.client.model.EntityModel;
import net.inveed.gwt.editor.client.model.JSEntity;
import net.inveed.gwt.editor.client.utils.IError;
import net.inveed.gwt.editor.client.utils.Promise;
import net.inveed.gwt.editor.client.utils.PromiseImpl;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;

public class EntityEditorDialog {
    private static final Logger LOG = Logger.getLogger(EntityEditorDialog.class.getName());
    private static final EntityEditorDialogBinder uiBinder = (EntityEditorDialogBinder)GWT.create(EntityEditorDialogBinder.class);
    private final JSEntity entity;
    private AbstractEntityEditorForm enityEditorForm;
    private PromiseImpl<Boolean, IError> closePromise;
    @UiField
    protected Button btnCancel;
    @UiField
    protected Button btnOk;
    @UiField
    protected Modal modal;
    @UiField
    protected ModalBody content;

    public EntityEditorDialog(JSEntity entity) {
        uiBinder.createAndBindUi(this);
        this.entity = entity;
    }

    public void validate() {
        if (this.enityEditorForm.validate()) {
            this.btnOk.setEnabled(true);
        } else {
            this.btnOk.setEnabled(false);
        }
    }

    @UiHandler(value={"btnOk"})
    protected void onOkClick(ClickEvent evt) {
        LOG.info("OK button clicked");
        if (!this.enityEditorForm.validate()) {
            this.validate();
            return;
        }
        this.enityEditorForm.applyChanges();
        JsonRPCTransaction tran = new JsonRPCTransaction();
        this.enityEditorForm.persist(tran);
        tran.commit().thenApply(JsonRPCTransactionResponse -> {
            this.modal.hide();
            this.modal.removeFromParent();
            if (this.closePromise != null) {
                this.closePromise.complete(true);
            }
            return null;
        }).onError((e, t) -> {
            this.modal.hide();
            this.modal.removeFromParent();
            if (this.closePromise != null) {
                this.closePromise.complete(false);
            }
            return null;
        });
    }

    @UiHandler(value={"btnCancel"})
    protected void onCancelClick(ClickEvent evt) {
        LOG.info("Cancel button clicked");
        this.modal.hide();
        this.modal.removeFromParent();
        if (this.closePromise == null) {
            return;
        }
        this.closePromise.complete(false);
    }

    public static AbstractEntityEditorForm getFormWidget(EntityModel model, EntityFormView view) {
        assert (model != null);
        assert (view != null);
        LOG.fine("Creating form creator...");
        IEntityEditorFactory formFactory = EntityEditorRegistry.INSTANCE.getFactory(model.getEntityName());
        if (formFactory != null) {
            LOG.fine("Instantiating form with factory...");
            AbstractEntityEditorForm ret = formFactory.create(view);
            if (ret != null) {
                return ret;
            }
        }
        LOG.fine("Using default form");
        return new AutoEntityEditorForm(view);
    }

    private void buildFormAndShow(String viewName, boolean isNewEntity) {
        EntityFormView view = this.entity.getModel().getFormView(viewName);
        if (view == null) {
            LOG.warning("Cannot find view with name " + viewName);
            return;
        }
        if (!isNewEntity) {
            LOG.info("Editing entity '" + this.entity.getModel() + "' with ID '" + this.entity.getID() + "'");
            this.modal.setTitle("Editing " + this.entity.getModel().getDisplayName(viewName) + ": " + this.entity.getDisplayValue());
        } else {
            LOG.info("Creating new entity");
            this.modal.setTitle("Creating new:" + this.entity.getModel().getDisplayName(viewName));
        }
        AbstractEntityEditorForm form = EntityEditorDialog.getFormWidget(this.entity.getModel(), view);
        if (form == null) {
            LOG.warning("Cannot create form");
            return;
        }
        LOG.fine("Form build successfully.");
        this.content.clear();
        this.content.add((Widget)form);
        if (form.getRequestedHeight() != null) {
            this.modal.setHeight(form.getRequestedHeight() + 30 + "");
        }
        if (form.getRequestedWidth() != null) {
            this.modal.setWidth(form.getRequestedWidth() + 5 + "");
        }
        LOG.fine("Binding form");
        form.bind(this.entity);
        LOG.fine("Opening modal window");
        form.addValueChangedListener(new AbstractPropertyEditor.ValueChangeListener(){

            @Override
            public void onValueChanged() {
                EntityEditorDialog.this.validate();
            }
        });
        this.enityEditorForm = form;
        int maxHeigh = Math.max((int)((double)Window.getClientHeight() * 0.95) - 150, 500);
        this.content.getElement().getStyle().setProperty("maxHeight", (double)maxHeigh, Style.Unit.PX);
        this.modal.show();
        this.validate();
    }

    public Promise<Boolean, IError> show(String viewName) {
        boolean isNew;
        RootContainer.INSTANCE.modalContainer.add((Widget)this.modal);
        this.btnOk.setEnabled(false);
        boolean bl = this.entity == null ? true : (isNew = this.entity.getID() == null);
        if (isNew) {
            this.buildFormAndShow(viewName, isNew);
        } else {
            Promise<Void, IError> p = this.entity.load();
            ProgressBarController.INSTANCE.add(p);
            p.thenApply(Void2 -> {
                try {
                    this.buildFormAndShow(viewName, isNew);
                }
                finally {
                    ProgressBarController.INSTANCE.remove(p);
                }
                return null;
            });
            p.onError((e, t) -> {
                ProgressBarController.INSTANCE.remove(p);
                LOG.severe("Cannot load entity with ID " + this.entity.getID());
                return null;
            });
        }
        PromiseImpl<Boolean, IError> ret = new PromiseImpl<Boolean, IError>();
        this.closePromise = ret;
        return ret;
    }

    static interface EntityEditorDialogBinder
    extends UiBinder<Widget, EntityEditorDialog> {
    }
}

