/*
 * Decompiled with CFR 0.152.
 */
package net.inveed.gwt.server.propbuilders;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.annotation.Annotation;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import net.inveed.commons.reflection.BeanPropertyDesc;
import net.inveed.gwt.server.annotations.UIAsName;
import net.inveed.gwt.server.propbuilders.IPropertyBuiler;

public abstract class AbstractPropertyBuilder<T extends Annotation>
implements IPropertyBuiler<T> {
    private T annotation;
    private String propertyName;
    private BeanPropertyDesc property;
    private Integer asNameIndex;

    @Override
    public boolean prepare(BeanPropertyDesc prop) {
        UIAsName asa;
        String forcedName;
        this.property = prop;
        this.annotation = prop.getAnnotation(this.getAnnotationType());
        if (this.annotation == null) {
            // empty if block
        }
        if ((forcedName = this.getForcedName()) != null && (forcedName = forcedName.trim()).length() > 0) {
            this.propertyName = forcedName;
        }
        if (this.propertyName == null) {
            JsonProperty jsonAnnotation = (JsonProperty)prop.getAnnotation(JsonProperty.class);
            this.propertyName = jsonAnnotation != null ? jsonAnnotation.value() : prop.getName();
        }
        if ((asa = (UIAsName)prop.getAnnotation(UIAsName.class)) != null) {
            this.asNameIndex = asa.value();
        }
        return true;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public BeanPropertyDesc getProperty() {
        return this.property;
    }

    protected T getAnnotation() {
        return this.annotation;
    }

    protected boolean isRequired() {
        if (this.isRequiredAnnotation()) {
            return true;
        }
        if (this.getProperty().getType().getType().isPrimitive()) {
            return true;
        }
        if (this.canBeEmpty()) {
            return false;
        }
        Column ca = (Column)this.getProperty().getAnnotation(Column.class);
        if (ca != null && !ca.nullable()) {
            return true;
        }
        JoinColumn jca = (JoinColumn)this.getProperty().getAnnotation(JoinColumn.class);
        if (jca != null && !jca.nullable()) {
            return true;
        }
        JoinColumns jcsa = (JoinColumns)this.getProperty().getAnnotation(JoinColumns.class);
        if (jcsa != null) {
            for (JoinColumn jc : jcsa.value()) {
                if (jc.nullable()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean canBeEmpty() {
        return false;
    }

    protected boolean isReadonly() {
        Boolean roa = this.isReadonlyAnnotation();
        if (roa != null && roa.booleanValue()) {
            return true;
        }
        return !this.getProperty().canSet();
    }

    protected Integer getAsNameIndex() {
        return this.asNameIndex;
    }

    protected abstract Class<T> getAnnotationType();

    protected abstract String getForcedName();

    protected abstract boolean isRequiredAnnotation();

    protected abstract Boolean isReadonlyAnnotation();
}

